import { Component, OnInit } from '@angular/core';
import {MyService} from '../my.service';
import { ModalService, ToastService } from 'ng-zorro-antd-mobile';
import { Router } from "@angular/router";
const extra = {
  '2017/07/15': { info: 'Disable', disable: true }
};

const now = new Date();
extra[+new Date(now.getFullYear(), now.getMonth(), now.getDate() + 5)] = { info: 'Disable', disable: true };
extra[+new Date(now.getFullYear(), now.getMonth(), now.getDate() + 6)] = { info: 'Disable', disable: true };
extra[+new Date(now.getFullYear(), now.getMonth(), now.getDate() + 7)] = { info: 'Disable', disable: true };
extra[+new Date(now.getFullYear(), now.getMonth(), now.getDate() + 8)] = { info: 'Disable', disable: true };

for (let key in extra) {
  if (extra.hasOwnProperty(key)) {
    let info = extra[key];
    const date = new Date(key);
    if (!Number.isNaN(+date) && !extra[+date]) {
      extra[+date] = info;
    }
  }
}

@Component({
  selector: 'ydlife-add-task',
  templateUrl: './add-task.component.html',
  styleUrls: ['./add-task.component.scss'],
})
export class AddTaskComponent implements OnInit {
  state: any = {
    en: false,
    date: null,
    show: false,
    pickTime: false,
    now: new Date(),
    type: 'range',
    enterDirection: '',
    rowSize: 'normal',
    showShortcut: false,
    infinite: true,
    defaultValue: undefined,
    minDate: new Date(+now - 5184000000),
    maxDate: new Date(+now + 31536000000),
    onSelect: undefined,
    getDateExtra: date => {
      return extra[+date];
    }
  }
  tabList:Array<any>;
  tabType:string;
  salesActivityList:Array<any>;
  taskImportantTag:boolean = false;
  seasons:Array<any>;
  taskTimeFrom:Array<any>=[];
  taskTimeEnd:Array<any> = [];
  longTermList:Array<any>;
  taskType:number;
  mdDropOptionId:any;
  notice:string;
  linkToastFlag:boolean = false;
  totastTitle:string;
  constructor(private myService:MyService,private router: Router) {
    this.seasons = [
      {label: '8:00',id:1},
      {label: '8:30',id:2},
      {label: '9:00',id:3},
      {label: '9:30', id:4},
      {label: '10:00',id:5},
      {label: '10:30',id:6},
      {label: '11:00',id:7},
      {label: '11:30',id:8},
      {label: '12:00',id:9},
      {label: '12:30',id:10},
      {label: '13:00',id:11},
      {label: '13:30',id:12},
      {label: '14:00',id:13},
      {label: '14:30',id:14},
      {label: '15:00',id:15},
      {label: '15:30',id:16},
      {label: '16:00',id:17},
      {label: '16:30',id:18},
      {label: '17:00',id:19},
      {label: '17:30',id:20},
      {label: '18:00',id:21},
      {label: '18:30',id:22},
      {label: '18:00',id:23},
      {label: '19:30',id:24},
      {label: '17:30',id:25},
      {label: '18:00',id:26},
      {label: '18:30',id:27},
      {label: '18:00',id:28},
      {label: '19:30',id:29},
    ];
    this.longTermList = [
      {name:'周一',isLongTermTask:false},
      {name:'周二',isLongTermTask:false},
      {name:'周三',isLongTermTask:false},
      {name:'周四',isLongTermTask:false},
      {name:'周五',isLongTermTask:false},
      {name:'周六',isLongTermTask:false},
      {name:'周日',isLongTermTask:false}
    ];
    
   }

   initPara() {
    this.state = {
      ...this.state,
      ...{
        show: false,
        date: null,
        pickTime: false,
        now: new Date(),
        type: 'range',
        rowSize: 'normal',
        infinite: true,
        enterDirection: '',
        onSelect: undefined,
        showShortcut: false,
        defaultValue: undefined,
        minDate: new Date(+now - 5184000000),
        maxDate: new Date(+now + 31536000000),
        getDateExtra: date => {
          return extra[+date];
        }
      }
    };
  }

  ngOnInit() {
    this.tabList = [{code:'bizchance_promotion_action',name:'营销',taskType:1},{code:'team_building_track',name:'增员',taskType:2},{code:'pep_schedule_task_others',name:'其他',taskType:3}];
    this.tabType = 'bizchance_promotion_action';
    this.dropOptionsQuery(this.tabType)
  }

  goBack(){
    history.go(-1);
  }

  selectTab(code,taskType){
    this.tabType = code;
    this.taskType = taskType;
    this.dropOptionsQuery(this.tabType);
  }

  dropOptionsQuery(code){
    this.myService.dropOptionsQuery({code:code}).subscribe((res)=>{
      if(res['success']){
        this.salesActivityList = res['data']['dropMasterInfoList'][0]['dropOptionsInfoList'];
      }
    })
  }
  onChange(result,type) {
    if(type===1){
      this.taskTimeFrom = result;
      console.log(this.taskTimeFrom);
    }
    if(type===2){
      console.log(this.taskTimeEnd)
      this.taskTimeEnd=result;
    }
  }

  selectTask(id){
    this.mdDropOptionId=id;
    if(this.tabType == 'bizchance_promotion_action' ){
      this.linkToastFlag = true;
      this.totastTitle = '商机';
    }
    if(this.tabType == 'team_building_track'){
      this.linkToastFlag = true;
      this.totastTitle = '增员';
    }
  }
  getValue(result) {
    let value = [];
    let temp = '';
    result.forEach(item => {
      value.push(item.label || item);
      temp += item.label || item;
    });
    return value;
  }

  onClick_0() {
    this.initPara();
    this.state.show = true;
    this.state.type = 'one';
    this.state.date = new Date();
  }

  triggerCancel() {
    this.state.show = false;
  }

  jumpToLink(){
    if(this.tabType == 'bizchance_promotion_action'){
      this.router.navigate(['/linkbusiness'])
    }
  }
}
