import { Component, OnInit } from '@angular/core';
import { MyService } from '../my.service';
import { LifeCommonService } from '../../common/life-common.service';
import { Router , ActivatedRoute} from "@angular/router";
@Component({
  selector: 'ydlife-my-business',
  templateUrl: './my-business.component.html',
  styleUrls: ['./my-business.component.scss'],
  styles: [
    `.am-demo-bd div{
        border-bottom: none;
      } 
  `]
})
export class MyBusinessComponent implements OnInit {
  businessList: Array<any>;
  isTaskCome:boolean = false;
  pageType:any;
  showBusinessList: Array<any>;
  isSelectFlag:boolean;
  constructor(private myService: MyService, public lifeCommonService: LifeCommonService, private router: Router,private activatedRoute: ActivatedRoute) { 
    this.pageType = this.activatedRoute.snapshot.data[0]['type'];
  }

  ngOnInit() {
    this.ownOpportunityQuery();
  }

  ownOpportunityQuery() {
    const brokerCustomerId = JSON.parse(localStorage.getItem('lifeCustomerInfo'))['customerId'];
    const brokerPractitionerId = JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId'];
    this.myService.ownOpportunityQuery({ customerId: brokerCustomerId, practitionerId: brokerPractitionerId }).subscribe((res) => {
      if (res['data']['ownOpportunityInfos']) {
        this.businessList = res['data']['ownOpportunityInfos'];
        this.showBusinessList = res['data']['ownOpportunityInfos'];
      } else {
        this.businessList = [];
      }
    })
  }

  addBussiness() {
    this.router.navigate(['/business/0']);
  }

  isJumpToDetail(opportunityId,orderId,leadsAssignedId){
    if(this.pageType == 'business'){
      this.router.navigate([`/business/${opportunityId}`], { queryParams: { orderId: orderId, leadsAssignedId: leadsAssignedId } });
    }else{
     return;
    }
  }

  change(event){
    this.showBusinessList = this.businessList.filter((item)=>{
      return item.name.indexOf(event) !=-1;
    })
  }
}
