import { Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { environment } from '../../environments/environment';
import { parse } from 'querystring';

@Injectable({
  providedIn: 'root'
})
export class MyService {
  constructor(private http: HttpClient) {
  }

  private API = environment.BACKEND_URL_CONFIG_VALUE;
  private ydapi = environment.ORIGINNAME;
  //  保存分享码
  shareCallBack(shareInfo) {
    const url = this.API + '/shareCallBack';
    return this.http
      .post(url, JSON.stringify(shareInfo));
  }

  //  文件下载
  filePath(itemType, itemId, fileCategory, code, mdDropOptionId) {
    const url = this.API + '/filePathQuery';
    return this.http
      .post(url, JSON.stringify({ itemType: itemType, itemId: itemId, fileCategory: fileCategory, code: code, mdDropOptionId: mdDropOptionId }));
  }

  //  重要公告
  announcementQuery(id, announcementTypeId) {
    const url = this.ydapi + '/market/announcementQuery';
    return this.http
      .post(url, JSON.stringify({ id: id, announcementTypeId: announcementTypeId }));
  }

  //  产品海报
  posterQuery(paginationInfo) {
    const url = this.ydapi + '/market/posterQuery';
    return this.http
      .post(url, JSON.stringify(paginationInfo));
  }

  //热销产品
  recommendPlanQuery(param) {
    const url = this.API + '/recommendPlanQuery';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //培训资料分类
  dropOptionsQuery(param) {
    const url = this.API + "/metadata/dropOptionsQuery";
    return this.http.post(url, JSON.stringify(param)).pipe(res => {
      return res;
    });
  }

  queryproductlistbytag(param) {
    const url = this.API + "/queryproductlistbytag";
    return this.http.post(url, JSON.stringify(param)).pipe(res => {
      return res;
    });
  }

  //经纪人商机列表
  ownOpportunityQuery(param) {
    const url = this.ydapi + "/practitioner/ownOpportunityQuery";
    return this.http.post(url, JSON.stringify(param)).pipe(res => {
      return res;
    });
  }

  //经纪人商机详情
  ownOpportunityDetailQuery(param) {
    const url = this.ydapi + "/practitioner/ownOpportunityDetailQuery";
    return this.http.post(url, JSON.stringify(param)).pipe(res => {
      return res;
    });
  }
  //经纪人修改商机跟进信息
  ownOpportunityRecordSave(param) {
    const url = this.ydapi + "/practitioner/ownOpportunityRecordSave";
    return this.http.post(url, JSON.stringify(param)).pipe(res => {
      return res;
    });
  }

  //标签列表查询
  tagQuery(param) {
    const url = this.API + "/metadata/tagQuery";
    return this.http.post(url, JSON.stringify(param)).pipe(res => {
      return res;
    });
  }

  //商机基本信息保存
  ownOpportunityBasicInformationSave(param) {
    const url = this.ydapi + "/practitioner/ownOpportunityBasicInformationSave";
    return this.http.post(url, JSON.stringify(param)).pipe(res => {
      return res;
    });
  }
  //获取省份
  provinceqry(param) {
    const url = this.API + "/partner/provinceqry";
    return this.http.post(url, JSON.stringify(param)).pipe(res => {
      return res;
    });
  }

  /**
   * 获取城市
   * @param objParam
   * @returns {Promise<TResult2|TResult1>}
   */
  cityqry(param) {
    const url = this.API + '/partner/cityqry';
    return this.http.post(url, JSON.stringify(param)).pipe(res => {
      return res;
    });
  }

  //查保单明细(不包括寿险)
  practitionerPolicyListQuery(practitionerId) {
    const url = this.API + '/practitioner/practitionerPolicyListQuery';
    return this.http
      .post(url, JSON.stringify(practitionerId));
  }

  //保单明细列表包括寿险
  policyListQuery(practitionerId) {
    const url = this.ydapi + '/practitioner/policyListQuery';
    return this.http
      .post(url, JSON.stringify(practitionerId));
  }

  //保单明细详细信息
  policyInfoQuery(practitionerId) {
    const url = this.ydapi + '/practitioner/policyInfoQuery';
    return this.http
      .post(url, JSON.stringify(practitionerId));
  }
  //查询团队业绩及是否团队长
  subordinateSystemMemberQuery(practitionerId) {
    const url = this.ydapi + '/practitioner/subordinateSystemMemberQuery';
    return this.http
      .post(url, JSON.stringify(practitionerId));
  }

  //下载多媒体文件接口
  mediaGet(mediaId) {
    const url = this.ydapi + '/practitioner/mediaGet';
    return this.http.post(url, JSON.stringify(mediaId));
  }

  //设置查询
  mySettingQuery(practitionerId) {
    const url = this.ydapi + '/practitioner/settingQuery';
    return this.http.post(url, JSON.stringify(practitionerId));
  }

  //我的设置保存
  mySettingSave(param) {
    const url = this.ydapi + '/practitioner/settingSave';
    return this.http.post(url, JSON.stringify(param));
  }

  //删除生活照
  myImgDelete(param) {
    const url = this.ydapi + '/practitioner/imgDelete';
    return this.http.post(url, JSON.stringify(param));
  }

  //排行榜
  rank(param) {
    const url = this.ydapi + '/practitioner/rank';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //新增增员接口
  recruit(param) {
    const url = this.ydapi + '/practitioner/recruit';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //创建增员跟进记录
  addRecruitTrack(param) {
    const url = this.ydapi + '/practitioner/addRecruitTrack';
    return this.http
      .post(url, JSON.stringify(param));
  }
  //增员查询跟进接口
  recruitTrackQuery(param) {
    const url = this.ydapi + '/practitioner/recruitTrackQuery';
    return this.http
      .post(url, JSON.stringify(param));
  }

  // 教育等级查询
  educationLevelQuery() {
    const url = this.API + '/metadata/educationLevelQuery';
    return this.http.get(url);
  }

  //增员列表查询
  recruitListQuery(param) {
    const url = this.ydapi + '/practitioner/recruitListQuery';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //过渡页心灵鸡汤
  knowledgeQry(param) {
    const url = this.API + '/metadata/knowledgeQry';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //经纪人商机分数统计
  opportunityStatistics(param) {
    const url = this.ydapi + '/practitioner/opportunityStatistics';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //销售目标保存
  salesTargetSave(param) {
    const url = this.ydapi + '/practitioner/salesTargetSave';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //查询销售目标
  salesTargetQuery(param) {
    const url = this.ydapi + '/practitioner/salesTargetQuery';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //月均销售活动量
  salesTargetMonthSave(param) {
    const url = this.ydapi + '/practitioner/salesTargetMonthSave';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //增员目标保存
  potentialGoalsSetting(param) {
    const url = this.ydapi + '/practitioner/potentialGoalsSetting';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //增员目标查询接口
  potentialGoalsQuery(param) {
    const url = this.ydapi + '/practitioner/potentialGoalsQuery';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //增员活动量更新
  potentialGoalsActionsUpdate(param) {
    const url = this.ydapi + '/practitioner/potentialGoalsActionsUpdate';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //活动量查询
  potentialGoalsActionsQuery(param) {
    const url = this.ydapi + '/practitioner/potentialGoalsActionsQuery';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //团队平均
  teamActionsAverageQuery(param) {
    const url = this.ydapi + '/practitioner/teamActionsAverageQuery';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //增员统计
  potentialActivityQuery(param) {
    const url = this.ydapi + '/practitioner/potentialActivityQuery';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //团队成员销售活动量得分
  playerSalesActivityQuery(param) {
    const url = this.ydapi + '/practitioner/playerSalesActivityQuery';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //战队成员销售业绩预测
  salesPerformanceForecastListQuery(param) {
    const url = this.ydapi + '/practitioner/salesPerformanceForecastListQuery';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //销售活动量分值详情
  salesScoreDetailQuery(param) {
    const url = this.ydapi + '/practitioner/salesScoreDetailQuery';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //薪资列表
  payScaleListQuery(param) {
    const url = this.ydapi + '/practitioner/payScaleListQuery';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //薪资pdf
  payScalePdf(param) {
    const url = this.ydapi + '/practitioner/payScalePdf';
    return this.http
      .post(url, JSON.stringify(param));
    // this.http.post(`${this.ydapi}/practitioner/payScalePdf`, param, { responseType: 'blob', observe: 'response' }).subscribe(data => {
    //   const link = document.createElement('a');
    //   const blob = new Blob([data.body], { type: 'application/pdf;charset=UTF-8' });
    //   link.setAttribute('href', window.URL.createObjectURL(blob));
    //   link.setAttribute('download', data.headers.get('Content-Disposition').split('filename=')[1]);
    //   link.style.visibility = 'hidden';
    //   document.body.appendChild(link);
    //   link.click();
    //   document.body.removeChild(link);
    // })
  }

  applyForExpertSupport(param){
  const url = this.ydapi + '/practitioner/applyForExpertSupport';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //日程跟进查询
  queryScheduleTrackList(param){
    const url = this.ydapi + '/practitioner/queryScheduleTrackList';
    return this.http
      .post(url, JSON.stringify(param));
  }
}
