import { Component, OnInit } from '@angular/core';
import { LifeCommonService } from '../../common/life-common.service';
import {MyService} from '../my.service';

@Component({
  selector: 'ydlife-todo-list',
  templateUrl: './todo-list.component.html',
  styleUrls: ['./todo-list.component.scss']
})
export class TodoListComponent implements OnInit {
  weekArr: Array<any>;
  taskList:Array<any> = [];
  taskTimeList:Array<any> = [];
  constructor(public lifeCommonService: LifeCommonService,private myService:MyService) {
    this.taskTimeList = [
      {id:1,time:'8:00'},
      {id:2,time:'9:00'},
      {id:3,time:'10:00'},
      {id:4,time:'11:00'},
      {id:5,time:'12:00'},
      {id:6,time:'13:00'},
      {id:7,time:'14:00'},
      {id:8,time:'15:00'},
      {id:9,time:'16:00'},
      {id:10,time:'17:00'},
      {id:11,time:'18:00'},
      {id:12,time:'19:00'},
    ]
   }
  
  ngOnInit() {
    this.weekArr = this.lifeCommonService.makeDate();
    this.queryScheduleTrackList();
  }

  goBack(){
    history.go(-1)
  }

  selectDay(weekItem){
    for(let i=0;i<this.weekArr.length;i++){
      this.weekArr[i].selected = false;
      if(weekItem.day == this.weekArr[i]['day']){
        this.weekArr[i].selected = true;
      }
    }
  }

  addTask(){
    // this.taskList.push({time:'8:00-9:00',isImportant:true,taskTitle:'今天要完成的计划1',taskContent:'app界面和网页界面的设计'});
  }

  queryScheduleTrackList(){
    this.myService.queryScheduleTrackList({practitionerId:'1',trackDate:'2020-09-11'}).subscribe((res)=>{
      console.log(res)
      if(res['success']){
        this.taskList = res['data'];
      }
    })
  }
}
