import { Component, OnInit } from '@angular/core';
import { MyService} from '../my.service';
import { ModalService, ToastService } from 'ng-zorro-antd-mobile';
import { Router,ActivatedRoute } from "@angular/router";
import { LifeCommonService} from '../../common/life-common.service';
import { TrackQuery} from '../../domain/trackQuery';
import * as dayjs from 'dayjs';

@Component({
  selector: 'ydlife-add-task',
  templateUrl: './add-task.component.html',
  styleUrls: ['./add-task.component.scss'],
})
export class AddTaskComponent implements OnInit {
  state: any = {
    en: false,
    date: null,
    show: false,
    pickTime: false,
    now: new Date(),
    type: 'one',
    enterDirection: '',
    rowSize: 'normal',
    showShortcut: false,
    infinite: true,
    defaultValue: undefined,
    minDate: new Date(+new Date() - 5184000000),
    maxDate: new Date(+new Date() + 31536000000),
    onSelect: undefined,
  }
  addTrack:TrackQuery = new TrackQuery()
  tabList:Array<any>;
  tabType:string;
  salesActivityList:Array<any>;
  seasons:Array<any>;
  longTermList:Array<any>;
  linkToastFlag:boolean = false;
  constructor(private myService:MyService,private router: Router,private _modal: ModalService, private _toast: ToastService,
   public lifeCommonService:LifeCommonService,private activateRoute:ActivatedRoute) {
    this.seasons = [
      {label: '8:00',id:1},
      {label: '8:30',id:2},
      {label: '9:00',id:3},
      {label: '9:30', id:4},
      {label: '10:00',id:5},
      {label: '10:30',id:6},
      {label: '11:00',id:7},
      {label: '11:30',id:8},
      {label: '12:00',id:9},
      {label: '12:30',id:10},
      {label: '13:00',id:11},
      {label: '13:30',id:12},
      {label: '14:00',id:13},
      {label: '14:30',id:14},
      {label: '15:00',id:15},
      {label: '15:30',id:16},
      {label: '16:00',id:17},
      {label: '16:30',id:18},
      {label: '17:00',id:19},
      {label: '17:30',id:20},
      {label: '18:00',id:21},
      {label: '18:30',id:22},
      {label: '19:00',id:23},
      {label: '19:30',id:24},
      {label: '20:00',id:25},
      {label: '20:30',id:26},
      {label: '21:00',id:27},
      {label: '21:30',id:28},
      {label: '22:00',id:29},
    ];
    // console.log(this.router.getCurrentNavigation().extras.state)
   }

   initPara() {
    this.state = {
      ...this.state,
      ...{
        show: false,
        date: null,
        pickTime: false,
        now: new Date(),
        type: 'one',
        rowSize: 'normal',
        infinite: true,
        enterDirection: '',
        onSelect: undefined,
        showShortcut: false,
        defaultValue: undefined,
      }
    };
  }

  ngOnInit() {
    this.addTrack.practitionerId = JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId'];
    this.tabList = [{code:'bizchance_promotion_action',name:'营销',taskType:1},{code:'team_building_track',name:'增员',taskType:2},{code:'pep_schedule_task_others',name:'其他',taskType:3}];
    this.tabType = 'bizchance_promotion_action';
    this.addTrack.taskType = 1;
    this.dropOptionsQuery(this.tabType);
    //如果有缓存切换到缓存数据
    if(JSON.parse(sessionStorage.getItem('pageDwellDtatus'))){
      this.tabType =  JSON.parse(sessionStorage.getItem('pageDwellDtatus'))['tabType'];
      this.addTrack.taskType = JSON.parse(sessionStorage.getItem('pageDwellDtatus'))['taskType'];
      setTimeout(() => {
        this.dropOptionsQuery(this.tabType);
      this.addTrack.mdDropOptionId = JSON.parse(sessionStorage.getItem('pageDwellDtatus'))['mdDropOptionId'];
      }, 300);
    }else{
      this.tabType = 'bizchance_promotion_action';
      this.addTrack.taskType = 1;
      this.addTrack.mdDropOptionId = null;
    }
    //如果有日程时间就取缓存没有就默认当天
    if(sessionStorage.getItem('trackTime')){
      this.addTrack.trackTime = sessionStorage.getItem('trackTime');
    }else{
      this.addTrack.trackTime = dayjs().format('YYYY-MM-DD');
    }
    this.addTrack.referLeadsId = this.activateRoute.snapshot.queryParams['referLeadsId'];
    this.addTrack.referPotentialId = this.activateRoute.snapshot.queryParams['referPotentialId'];
    this.addTrack.customerId = this.activateRoute.snapshot.queryParams['customerId'];
  }

  goBack(){
    history.go(-1);
  }

  //判断是否选择同一个tab
  selectTab(code,taskType){
    let pageDwellDtatus = {};
    if(this.tabType == code){
       pageDwellDtatus = {
        tabType:this.tabType,
        mdDropOptionId:this.addTrack.mdDropOptionId,
        taskType:this.addTrack.taskType
      }
      sessionStorage.setItem('pageDwellDtatus',JSON.stringify(pageDwellDtatus));
    }else{
      this.tabType = code;
      this.addTrack.taskType = taskType;
      this.addTrack.mdDropOptionId = null;
      if(this.addTrack.taskType == 1 || this.addTrack.taskType == 2){
        this.addTrack.taskRoutineAtweek1 = undefined;
        this.addTrack.taskRoutineAtweek2 = undefined;
        this.addTrack.taskRoutineAtweek3 = undefined;
        this.addTrack.taskRoutineAtweek4 = undefined;
        this.addTrack.taskRoutineAtweek5 = undefined;
        this.addTrack.taskRoutineAtweek6 = undefined;
        this.addTrack.taskRoutineAtweek7 = undefined;
      }
      this.dropOptionsQuery(this.tabType);
      pageDwellDtatus = {
        tabType:this.tabType,
        mdDropOptionId:null,
        taskType:this.addTrack.taskType
      }
      sessionStorage.setItem('pageDwellDtatus',JSON.stringify(pageDwellDtatus));
    } 
  }

  dropOptionsQuery(code){
    this.myService.dropOptionsQuery({code:code}).subscribe((res)=>{
      if(res['success']){
        this.salesActivityList = res['data']['dropMasterInfoList'][0]['dropOptionsInfoList'];
      }
    })
  }

  onChange(result,type) {
    if(type===1){
      this.addTrack.taskTimeFrom = result;
    }
    if(type===2){
      this.addTrack.taskTimeEnd = result;
    }
    console.log(this.addTrack.taskTimeFrom,this.addTrack.taskTimeEnd)
  }

  selectTask(id){
    this.addTrack.mdDropOptionId=id;
    const pageDwellDtatus = {
      tabType:this.tabType,
      mdDropOptionId:this.addTrack.mdDropOptionId,
      taskType:this.addTrack.taskType
    }
    sessionStorage.setItem('pageDwellDtatus',JSON.stringify(pageDwellDtatus));
    if(this.tabType == 'bizchance_promotion_action' ){
      ModalService.alert('是否联系到商机', '', [
        { text: '否', onPress: () =>  
          this.clearRouterInfo(),
          style: {
            borderTop:'1px #ddd solid'
          }
        },
        { text: '是', onPress: () => this.jumpToLink(),
          style: {
            color: '#f8002e',
            background: '',
            borderLeft:'1px #ddd solid',
            borderTop:'1px #ddd solid'
          }
       },
      ]);
    }
    if(this.tabType == 'team_building_track'){
      ModalService.alert('是否联系到增员', '', [
        { text: '否', onPress: () =>  this.clearRouterInfo(),
          style: {
            borderTop:'1px #ddd solid'
          }
        },
        { text: '是', onPress: () => this.jumpToLink(),
          style: {
            color: '#f8002e',
            background: '',
            borderLeft:'1px #ddd solid',
            borderTop:'1px #ddd solid'
          }
       },
      ]);
    }
  }

  clearRouterInfo(){
    this.linkToastFlag=false,
    this.router.navigate(['/addtask'], {replaceUrl: true});
  }

  clickCalendar(){
    this.initPara();
    this.state.show = true;
    this.state.date = new Date();
  }

  triggerCancel() {
    this.state.show = false;
  }

  triggerConfirm(value) {
    const { startDate, endDate } = value;
    this.state = {
      ...this.state,
      ...{ show: false, startDate, endDate }
    };
    this.triggerCancel();
    this.addTrack.trackTime = dayjs(startDate).format('YYYY-MM-DD');

  }

  jumpToLink(){
    if(this.tabType == 'bizchance_promotion_action'){
      this.router.navigate(['/linkbusiness'])
    }
    if(this.tabType == 'team_building_track'){
      this.router.navigate(['/linkrecruiting'])
    }
  }

  //选择长期任务
  selectIsLongTermTask(type){
    if(type===1){
      this.addTrack.taskRoutineAtweek1 == 1?this.addTrack.taskRoutineAtweek1 = 0:this.addTrack.taskRoutineAtweek1 = 1;
    }
    if(type===2){
      this.addTrack.taskRoutineAtweek2 == 1?this.addTrack.taskRoutineAtweek2 = 0:this.addTrack.taskRoutineAtweek2 = 1;
    }
    if(type===3){
      this.addTrack.taskRoutineAtweek3 == 1?this.addTrack.taskRoutineAtweek3 = 0:this.addTrack.taskRoutineAtweek3 = 1;
    }
    if(type===4){
      this.addTrack.taskRoutineAtweek4 == 1?this.addTrack.taskRoutineAtweek4 = 0:this.addTrack.taskRoutineAtweek4 = 1;
    }
    if(type===5){
      this.addTrack.taskRoutineAtweek5 == 1?this.addTrack.taskRoutineAtweek5 = 0:this.addTrack.taskRoutineAtweek5 = 1;
    }
    if(type===6){
      this.addTrack.taskRoutineAtweek6 == 1?this.addTrack.taskRoutineAtweek6 = 0:this.addTrack.taskRoutineAtweek6 = 1;
    }
    if(type===7){
      this.addTrack.taskRoutineAtweek7 == 1?this.addTrack.taskRoutineAtweek7 = 0:this.addTrack.taskRoutineAtweek7 = 1;
    }
  }

  clickAddTask(){
    console.log(this.addTrack)
    if(!this.addTrack.mdDropOptionId){
      const toast = ToastService.show('请选择您要添加的日程分类!', 0);
      setTimeout(() => {
        ToastService.hide();
      }, 3000);
      return;
    }
    if(!this.addTrack.taskTimeFrom ){
      const toast = ToastService.show('请选择任务需要的起始时间!', 0);
      setTimeout(() => {
        ToastService.hide();
      }, 3000);
      return;
    }
    if(!this.addTrack.taskTimeEnd){
      const toast = ToastService.show('请选择任务需要的结束时间!', 0);
      setTimeout(() => {
        ToastService.hide();
      }, 3000);
      return;
    }
    this.addTrack = {
        ...this.addTrack,
        taskImportantTag:this.addTrack.taskImportantTag?1:0,
        isActive:1,
        taskTimeFrom:this.addTrack.taskTimeFrom[0]['label'],
        taskTimeEnd:this.addTrack.taskTimeEnd[0]['label']
    }
    this.myService.addScheduleTrack(this.addTrack).subscribe((res)=>{
      const toast = ToastService.show(`${res['message']}`, 0);
      setTimeout(() => {
        ToastService.hide();
      }, 3000);
    })
  }
}
