import { Component, OnInit } from '@angular/core';
import { MyService } from '../my.service';
import { LifeCommonService } from '../../common/life-common.service';
import { ActivatedRoute,Router } from "@angular/router";

@Component({
  selector: 'ydlife-salary',
  templateUrl: './salary.component.html',
  styleUrls: ['./salary.component.scss']
})
export class SalaryComponent implements OnInit {
  practitionerIdEG: any;
  practitionerId: any;
  payScaleInfos: Array<any>;
  //控制弹框
  toastDialog: boolean;
  toastInfo: any;
  tabList:Array<any>;
  selectedId:any = 0;
  constructor(private activatedRoute: ActivatedRoute,private myService: MyService,
     public lifeCommonService: LifeCommonService,
     private router: Router) { }

  ngOnInit() {
    const title = this.activatedRoute.snapshot.data[0]['title'];
    this.lifeCommonService.setTitle(title);
    this.practitionerIdEG = JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerIdEG'];
    this.practitionerId = JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId']
    this.payScaleListQuery();
    this.tabList = [
      {name:'2021年',id:0},
      {name:'历史薪资',id:1}
    ]
  }

  payScaleListQuery() {
    this.myService.payScaleListQuery({ practitionerIdEG: this.practitionerIdEG,practitionerId:this.practitionerId,isHistory: this.selectedId}).subscribe((res) => {
      if (res['success']) {
        this.payScaleInfos = res['data']['payScaleInfos'];
      } else {
        this.payScaleInfos = [];
      }
    })
  }


  selectTab(tabId){
    this.selectedId = tabId;
    this.payScaleListQuery();
  }

  //进入薪资详情
  enterDetail(years,month,agent_id){
    this.router.navigate(['/salary_detail'],{ queryParams: { years:years,month:month,agent_id:agent_id} });
  }
}

