import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';

@Component({
  selector: 'ydlife-yd-college',
  templateUrl: './yd-college.component.html',
  styleUrls: ['./yd-college.component.scss']
})
export class YdCollegeComponent implements OnInit {
  public courseLists = [
    {no:23,name:'保险ABC',icon:'insuranceABCDisabled',link:'',path:`https://${window.location.host}/issue`,isOpen:false},
    {no:24,name:'岗前训',icon:'preJobTrainingDisabled',link:'/prejobTraining',path:'',isOpen:false},
    {no:25,name:'新人训',icon:'newTrainingDisabled',link:'/newTraining',path:'',isOpen:false},
    {no:26,name:'提升训',icon:'promotionTrainingDisabled',link:'/advanceTraining',path:'',isOpen:false},
    {no:27,name:'CFFP培训',icon:'cffpTrainingDisabled',link:'/cffpTraining',path:'',isOpen:false},
    {no:28,name:'产品培训',icon:'productTrainingDisabled',link:'/productTraining',path:'',isOpen:false},
    {no:29,name:'我的培训',icon:'trainingDisabled',link:'',path:'',isOpen:false},
  ]

  public state = {
    modal1:false
  }

  onClose(key) {
    this.state[key] = false;
  }
  featureSelect(item){
    if(!item.isOpen){
      this.state['modal1'] = true;
    }
    if(item.path){
      window.open(item.path);
    }else if(item.link){
      this.router.navigate([`./${item.link}`]);
    }
  }
  constructor(private router:Router) { }

  ngOnInit() {
  }

}
