import { Component, OnInit } from '@angular/core';
import { MyService } from '../my.service';
import { LifeCommonService } from '../../common/life-common.service';
@Component({
  selector: 'ydlife-team-panel',
  templateUrl: './team-panel.component.html',
  styleUrls: ['./team-panel.component.scss']
})
export class TeamPanelComponent implements OnInit {
  //战队名称
  subordinateSystemName: any;
  teamActionsData: any;
  //保费
  premiums: number;
  //佣金
  commission: number;
  //件数
  count: number;
  //完成率
  completionRates: number;
  selectedSalseItem: any;
  selectedSalseItemName: any;
  practitionerId: any;
  recruitingStatistics: any;
  selectedRecruitingItem: any;
  statisticInfo: any;
  averageData:any;
  constructor(private myService: MyService, public lifeCommonService: LifeCommonService) { }
  ngOnInit() {
    this.practitionerId = JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId'];
    this.subordinateSystemName = sessionStorage.getItem('subordinateSystemName');
    this.teamActionsAverageQuery();
    // this.potentialActivityQuery();
    this.subordinateSystemMemberQuery(1);
    this.queryPEPScore();
  }

  teamActionsAverageQuery() {
    this.myService.teamActionsAverageQuery({ practitionerId: this.practitionerId }).subscribe((res) => {
      if (res['success']) {
        this.teamActionsData = res['data'];
        this.selectSales('month')
      }
    })
  }

  selectSales(type) {
    this.selectedSalseItem = type;
    if (type === 'month') {
      this.selectedSalseItemName = '本月';
      this.premiums = this.teamActionsData.premiumMonth;
      this.commission = this.teamActionsData.commissionMonth;
      this.count = this.teamActionsData.piecesMonth;
      this.completionRates = this.teamActionsData.achievementRateMonth;
    }
    if (type === 'quarter') {
      this.selectedSalseItemName = '本季';
      this.premiums = this.teamActionsData.premiumQuarter;
      this.commission = this.teamActionsData.commissionQuarter;
      this.count = this.teamActionsData.piecesQuarter;
      this.completionRates = this.teamActionsData.achievementRateQuarter;
    }
    if (type === 'year') {
      this.selectedSalseItemName = '本年';
      this.premiums = this.teamActionsData.premiumYear;
      this.commission = this.teamActionsData.commissionYear;
      this.count = this.teamActionsData.piecesYear;
      this.completionRates = this.teamActionsData.achievementRateYear;
    }
  }

  subordinateSystemMemberQuery(type) {
    this.selectedRecruitingItem = type;
    const param = {
      time: type,
      practitionerId: this.practitionerId
    }
    this.myService.subordinateSystemMemberQuery(param).subscribe((res) => {
      if (res['success']) {
        this.statisticInfo = res['data']['statisticInfo'];
      }
      if(!this.statisticInfo){
        this.statisticInfo = {
          fyp:0,
          fyc:0,
          count:0,
          completionRate:0
        }
      }
    })
  }

  //增员统计
  // potentialActivityQuery() {
  //   this.myService.potentialActivityQuery({ practitionerId: this.practitionerId }).subscribe((res) => {
  //     if (res['success']) {
  //       this.recruitingStatistics = res['data'];
  //     }
  //   })
  // }

  //活动量得分统计
  queryPEPScore(){
    this.myService.queryPEPScore({ practitionerId: this.practitionerId }).subscribe((res)=>{
      if(res['success']){
        this.averageData = res['data']['average'];
      }
    })
  }
}
