import { Component, OnInit } from '@angular/core';
import { ModalService, ToastService } from 'ng-zorro-antd-mobile';
import { ActivatedRoute,Router } from "@angular/router";
import { MyService} from '../my.service';
@Component({
  selector: 'ydlife-approval-comments',
  templateUrl: './approval-comments.component.html',
  styleUrls: ['./approval-comments.component.scss']
})
export class ApprovalCommentsComponent implements OnInit {
  rejectNote:string;
  interviewAssessment:string;
  approvingStatus:number;
  hiringBasicInfoId:any;
  approvalIdentity:any;
  practitionerId:any;
  isNeedAlert: boolean;
  dialogInfo: any;
  constructor(private myService:MyService,private _modal: ModalService, private _toast: ToastService,private activatedRoute: ActivatedRoute,
    private router: Router) { }

  ngOnInit() {
    this.hiringBasicInfoId = this.activatedRoute.snapshot.queryParams.hiringBasicInfoId?this.activatedRoute.snapshot.queryParams.hiringBasicInfoId:null;
    this.approvalIdentity = this.activatedRoute.snapshot.queryParams.approvalIdentity?this.activatedRoute.snapshot.queryParams.approvalIdentity:null;
    this.practitionerId = JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId'];

  }

  showAlert(approvingStatus) {
    this.approvingStatus = approvingStatus;
    ModalService.alert('确认审批', `是否确定${this.approvingStatus==1?'通过':'拒绝'}该经纪人报聘？`, [
      { text: '取消', onPress: () => console.log('取消') },
      { text: '确定', onPress: () =>  this.hiringApprove()}
    ]);
  }

  hiringApprove(){
    // if(!this.interviewAssessment){
    //   this.openPopInfo('请输入您的面试意见！');
    //   return;
    // }
    const param = {
      practitionerId:this.practitionerId,
      hiringBasicInfoId:this.hiringBasicInfoId,
      approvingStatus: this.approvingStatus,
      rejectNote:this.rejectNote,
      interviewAssessment:this.interviewAssessment,
      plateform:1,
      hiringApproveStepsSeq:sessionStorage.getItem('hiringApproveStepsSeq')
    }
    this.myService.hiringApprove(param).subscribe((res)=>{
      this.openPopInfo(res['message']);
      setTimeout(() => {
        
      }, 3000);
    })
  }

   // 打开弹窗
   openPopInfo(message) {
    this.isNeedAlert = true;
    this.dialogInfo = {
      title: null,
      content: { value: message, align: 'center' },
      footer: [{ value: '我知道了', routerLink: '', className: 'weui-dialog__btn_primary' }],
    };
  }

  // 关闭弹窗
  getPopInfo() {
    this.isNeedAlert = false;
  }
}
