import { Component, OnInit } from '@angular/core';
import { MyService } from '../my.service';
import { ActivatedRoute } from '@angular/router';

@Component({
  selector: 'ydlife-member-detail',
  templateUrl: './member-detail.component.html',
  styleUrls: ['./member-detail.component.scss']
})
export class MemberDetailComponent implements OnInit {
  practitionerId:any;
  subordinateSystemName: any;
  teamMemberList:Array<any>;
  practitionerDeatil:any;
  constructor(private activateRoute: ActivatedRoute,private myService:MyService) { }

  ngOnInit() {
    this.practitionerId = Number(this.activateRoute.snapshot.paramMap.get('practitionerId'));
    this.subordinateSystemName = sessionStorage.getItem('subordinateSystemName');
    this.queryTeamMemberDetail();
  }

  queryTeamMemberDetail(){
    const practitionerId = JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId'];
    this.myService.queryTeamMemberDetail({practitionerId:practitionerId}).subscribe((res)=>{
      if(res['success']){
        this.teamMemberList = res['data']['teamMemberDetail'];
        console.log(this.teamMemberList)
        this.practitionerDeatil = this.teamMemberList.filter((item)=>{
          return item.practitionerId == this.practitionerId ;
        })[0];
      }
    })
  }
}
