import { Component, OnInit } from '@angular/core';
import { ActivatedRoute,Router } from "@angular/router";
import { LifeCommonService } from "../../../common/life-common.service";
import { MyService } from '../../my.service';
@Component({
  selector: 'ydlife-employee-info',
  templateUrl: './employee-info.component.html',
  styleUrls: ['./employee-info.component.scss']
})
export class EmployeeInfoComponent implements OnInit {
  hiringBasicInfoId:any;
  membership:any;
  mobileNo:string;
  approveStatus:any;
  constructor(private activatedRoute: ActivatedRoute,
    private router: Router,public lifeCommonService:LifeCommonService,
    public myService:MyService) { }

  ngOnInit() {
    const title = this.activatedRoute.snapshot.data[0]['title'];
    this.lifeCommonService.setTitle(title);
    this.hiringBasicInfoId = this.activatedRoute.snapshot.queryParams.hiringBasicInfoId?this.activatedRoute.snapshot.queryParams.hiringBasicInfoId:null;
    this.mobileNo = this.activatedRoute.snapshot.queryParams.mobileNo?this.activatedRoute.snapshot.queryParams.mobileNo:null;
    this.queryWholeInfo(this.hiringBasicInfoId)
  }

  next(){
    this.router.navigate(['/employee_basic_info'],{ queryParams: { hiringBasicInfoId:this.hiringBasicInfoId,mobileNo:this.mobileNo} });
  }

  queryWholeInfo(hiringBasicInfoId){
    this.myService.queryWholeInfo({hiringBasicInfoId:hiringBasicInfoId}).subscribe((res)=>{
      this.membership = res['data']['hiringMemberShip'];
      this.approveStatus = res['data']['hiringBasicInfo']['approveStatus'];
    })
  }

  goBack(){
    history.go(-1)
  }
  
  viewNext(){
    this.router.navigate(['/employee_basic_info'],{ queryParams: { hiringBasicInfoId:this.hiringBasicInfoId} });
  }
}
