import { Component, OnInit } from '@angular/core';
import { MyService } from '../my.service';
import { ActivatedRoute } from "@angular/router";

@Component({
  selector: 'ydlife-order-detail',
  templateUrl: './order-detail.component.html',
  styleUrls: ['./order-detail.component.scss']
})
export class OrderDetailComponent implements OnInit {
  orderNo: string;
  policyInfo: any;
  holderInfo: any;
  insuredInfos: Array<any>;
  policyFactorInfos: Array<any>;
  constructor(private myService: MyService, private activatedRoute: ActivatedRoute) { }

  ngOnInit() {
    this.orderNo = this.activatedRoute.snapshot.queryParams.orderNo;
    this.policyInfoQuery();
  }
  policyInfoQuery() {
    this.myService.policyInfoQuery({ orderNo: this.orderNo, platform: 2 }).subscribe((res) => {
      if (res['success']) {
        this.policyInfo = res['data'];
        this.holderInfo = this.policyInfo['holderInfo'];
        this.insuredInfos = this.policyInfo['insuredInfos'];
        this.policyFactorInfos = this.policyInfo['policyFactorInfos'];
      }
    })
  }
}
