import { Component, OnInit } from '@angular/core';
import { MyService } from '../my.service';
import { ActivatedRoute } from '@angular/router';

@Component({
  selector: 'ydlife-member-detail',
  templateUrl: './member-detail.component.html',
  styleUrls: ['./member-detail.component.scss']
})
export class MemberDetailComponent implements OnInit {
  practitionerId:any;
  subordinateSystemName: any;
  teamMemberList:Array<any>;
  practitionerDeatil:any;
  teamList:Array<any>;
  constructor(private activateRoute: ActivatedRoute,private myService:MyService) { }

  ngOnInit() {
    this.practitionerId = Number(this.activateRoute.snapshot.paramMap.get('practitionerId'));
    this.queryTeamMemberDetail();
  }

  queryTeamMemberDetail(){
    this.myService.queryTeamMemberDetail({practitionerId:this.practitionerId}).subscribe((res)=>{
      if(res['success']){
        this.teamMemberList = res['data']['teamMemberDetail'];
        this.teamList = res['data']['teamMemberList'];
        this.subordinateSystemName = res['data']['systemName'];
        let allArr = this.teamMemberList.concat(this.teamList)
        this.practitionerDeatil = allArr.filter((item)=>{
          return item.practitionerId == this.practitionerId ;
        })[0];
      }
    })
  }
}
