import { Component, OnInit } from '@angular/core';
import { ActivatedRoute, Router } from "@angular/router";
import { MyService } from '../my.service';
import { LifeCommonService } from '../../common/life-common.service';

@Component({
  selector: 'ydlife-member-list',
  templateUrl: './member-list.component.html',
  styleUrls: ['./member-list.component.scss']
})
export class MemberListComponent implements OnInit {
  practitionerId: any;
  subordinateSystemName: any;
  teamMemberList:Array<any>;
  systemType:any;
  teamList:Array<any>;
  sid:any;
  constructor(private activatedRoute: ActivatedRoute, private router: Router,
    private myService: MyService, public lifeCommonService: LifeCommonService) { }

  ngOnInit() {
    this.practitionerId = JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId'];
    this.systemType = this.activatedRoute.snapshot.paramMap.get('systemType');
    this.sid = this.activatedRoute.snapshot.queryParams.sid?this.activatedRoute.snapshot.queryParams.sid:null;
    this.queryTeamMemberDetail()
  }

  //下级列表和团队成员列表
  queryTeamMemberDetail(){
    this.myService.queryTeamMemberDetail({systemType:this.systemType,sid:this.sid}).subscribe((res)=>{
      if(res['success']){
        this.teamMemberList = res['data']['teamMemberDetail'];
        this.teamList = res['data']['teamMemberList'];
        this.subordinateSystemName = res['data']['systemName'];
      }
    })
  }

  goToList(itemInfo) { 
    window.location.href = `https://${window.location.host}/ydLife/member_list/${itemInfo.systemType}?sid=${itemInfo.sid}`
  }

}
