import { Component, OnInit } from '@angular/core';
import { ActivatedRoute,Router } from "@angular/router";
import { MyService } from '../my.service';

@Component({
  selector: 'ydlife-my-customer-policy',
  templateUrl: './my-customer-policy.component.html',
  styleUrls: ['./my-customer-policy.component.scss']
})
export class MyCustomerPolicyComponent implements OnInit {
  policyList:Array<any>;
  customerId:any;
  constructor(private activatedRoute: ActivatedRoute,private myService:MyService,private router:Router) { }

  ngOnInit() {
    this.customerId = this.activatedRoute.snapshot.queryParams.customerId?this.activatedRoute.snapshot.queryParams.customerId:null;
    this.queryPolicyListByHolderCustomerId();
  }

  queryPolicyListByHolderCustomerId(){
    this.myService.queryPolicyListByHolderCustomerId({holderCustomerId:this.customerId,practitionerCustomerId: JSON.parse(localStorage.getItem('lifeCustomerInfo'))['customerId']}).subscribe((res)=>{
      if(res['success']){
          this.policyList = res['data']['list'];
      }
    })
  }

  jumpToOrderdetail(orderNo) {
      this.router.navigate(['/orderDetail'], { queryParams: { orderNo:orderNo } });
  }
}
