import { Component, OnInit } from '@angular/core';
import { MyService } from '../my.service';
import { ActivatedRoute,Router } from "@angular/router";
import { LifeCommonService } from "../../common/life-common.service";
import { ModalService, ToastService } from 'ng-zorro-antd-mobile';

@Component({
  selector: 'ydlife-my-customer',
  templateUrl: './my-customer.component.html',
  styleUrls: ['./my-customer.component.scss']
})
export class MyCustomerComponent implements OnInit {
  customerList:Array<any>;
  practitionerId:any;
  constructor(private _toast: ToastService,private activatedRoute: ActivatedRoute,
    private router: Router,public lifeCommonService:LifeCommonService,
    public myService:MyService) { }

  ngOnInit() {
    this.lifeCommonService.setTitle('我的客户');
    this.practitionerId = JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId'];
    // this.customerList = [
    //   {name:'王倩',mobileNo:'13112210000',gender:'女',birthDate:'1990-12-13'},
    //   {name:'张三',mobileNo:'13451511111',gender:'男',birthDate:'1987-01-08'},
    //   {name:'李四',mobileNo:'13451511122',gender:'男',birthDate:'1989-03-21'},
    // ]
    this.queryCustomerHolderList()
  }

  addBussiness(customerItem) {
    localStorage.setItem('myCustomerInfo',JSON.stringify(customerItem))
    this.router.navigate(['/business/0']);
  }

  jumpToRelation(customerId){
    this.router.navigate(['/customer_relation'],{ queryParams: { customerId:customerId} });
  }
  
  jumpToPolicy(customerId){
    this.router.navigate(['/customer_policy'],{ queryParams: { customerId:customerId} })
  }

  //我的客户
  queryCustomerHolderList(){
    this.myService.queryCustomerHolderList(this.practitionerId).subscribe((res)=>{
        if(res['success']){
          this.customerList = res['data']['list'];
        }else{
          this.customerList = [];
          const toast = ToastService.show(res['message'], 0);
          setTimeout(() => {
            ToastService.hide();
          }, 3000);
        }
    })
  }
}
