import { Component, OnInit } from '@angular/core';
import { MyService } from '../my.service';
import { ActivatedRoute } from "@angular/router";

@Component({
  selector: 'ydlife-order-detail',
  templateUrl: './order-detail.component.html',
  styleUrls: ['./order-detail.component.scss']
})
export class OrderDetailComponent implements OnInit {
  orderNo: string;
  policyInfo: any;
  holderInfo: any;
  policyNo:string;
  insuredInfos: Array<any>;
  policyFactorInfos: Array<any>;
  relation_id:string;
  orderDetail:any;
  constructor(private myService: MyService, private activatedRoute: ActivatedRoute) { }

  ngOnInit() {
    this.orderNo = this.activatedRoute.snapshot.queryParams.orderNo;
    this.policyNo = this.activatedRoute.snapshot.queryParams.policyNo;
    this.relation_id = this.activatedRoute.snapshot.queryParams.relation_id;
    if(this.relation_id){
      this.policyInfoQuery();
    }else{
      this.orderQuery();
    }
  }
  policyInfoQuery() {
    this.myService.policyInfoQuery({ orderNo: this.orderNo, platform: 2,policyNo:this.policyNo,relation_id:this.relation_id }).subscribe((res) => {
      if (res['success']) {
        this.policyInfo = res['data'];
        this.holderInfo = this.policyInfo['holderInfo'];
        this.insuredInfos = this.policyInfo['insuredInfos'];
        this.policyFactorInfos = this.policyInfo['policyFactorInfos'];
      }
    })
  }

  orderQuery(){
    this.myService.orderDetailQuery({orderNo:this.orderNo}).subscribe((res)=>{
      if(res['success']){
        this.orderDetail = res['data']['orderDetail'];
        this.holderInfo = this.orderDetail['holderItem'];
        this.insuredInfos = this.orderDetail['insureds'];
      }
    })
  }

  getChineseDate(str) {
    if (str == "Y") {
      return "年";
    }
    if (str == "M") {
      return "月";
    }
    if (str == "D") {
      return "日";
    }
    if (str == "A") {
      return "岁";
    }
    return '';
  }

  getVehicleCategory(str) {
    if (str == "01") {
      return "客车";
    }
    if (str == "02") {
      return "货车";
    }
    return str;
  }
}
