import { Component, OnInit } from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';
import { MyService } from '../my.service';

@Component({
  selector: 'ydlife-renewal-reminder',
  templateUrl: './renewal-reminder.component.html',
  styleUrls: ['./renewal-reminder.component.scss']
})
export class RenewalReminderComponent implements OnInit {
  index:number = 0;
  practitionerId:number;
  lists:Array<any>;
  selectTab(i){
    this.index = i;
    this.queryNoticeList();
    this.router.navigate(['/renewal_reminder'], {queryParams:{i:this.index}});
  }
  constructor(private myService:MyService,private route:ActivatedRoute,private router:Router) {
    this.index = this.route.snapshot.queryParams['i'] ? this.route.snapshot.queryParams['i'] : 0;
  }

  ngOnInit() {
    this.practitionerId = localStorage.getItem('lifeCustomerInfo')?JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId']:null;
    this.queryNoticeList()
  }

  queryNoticeList(){
    this.myService.queryNoticeList({practitionerId:this.practitionerId,status:this.index}).subscribe(res=>{
      if(res['success']){
        this.lists = res['data']['list'];
      }
    })
  }

}
