import { Component, OnInit } from '@angular/core';
import { LifeCommonService } from '../../common/life-common.service';
import { ActivatedRoute,Router } from "@angular/router";


@Component({
  selector: 'ydlife-salary-detail',
  templateUrl: './salary-detail.component.html',
  styleUrls: ['./salary-detail.component.scss']
})
export class SalaryDetailComponent implements OnInit {
  monDtlPeriod:string;
  takFlag:boolean = false;
  taxToastShow:boolean;
  otherToastShow:boolean;
  salaryDetailsList:Array<any>;
  //首年度销售佣金
  fycSalesInfo:any = null;
  //续年度销售佣金
  rycSalesInfo:any = null;
  //首年度辅导奖
  fycTutorInfo:any = null;
  //续年度辅导奖
  rycTutorInfo:any = null;
  //首年度绩效奖金
  fycMeritsInfo:any = null;
  //续年度续缴奖
  rycMeritsInfo:any = null;
  //推介奖
  recommendAward:any = null;
  //体系推介奖
  systemRecommendAward:any = null;
  //特别管理奖
  specialManagementAward:any = null;
  //其他税前加扣款
  otherPreTaxDeduction:any = null;
  //激励奖金
  IncentiveBonus:any = null;
  //加码奖金
  addWeight:any = null;
  //季度奖
  quarterlyBonus:any = null;
  //银盾在线奖
  onlineAward:any = null;
  constructor(public lifeCommonService: LifeCommonService,
    private activatedRoute: ActivatedRoute,
    private router:Router) { }

  ngOnInit() {
    this.monDtlPeriod = this.activatedRoute.snapshot.queryParams.monDtlPeriod?this.activatedRoute.snapshot.queryParams.monDtlPeriod:null;
    this.lifeCommonService.setTitle(`${this.lifeCommonService.getDate(this.monDtlPeriod)}本期实发佣金`);
    this.salaryDetailsList = [
      {
        "Project_id": "54DB1075-AEF2-5F4C-ABDF-899F9EB66439",
        "SalaryName": "银盾首年度销售佣金",
        "SalaryType": "业绩佣金",
        "commission": 348359.37,
    },
    {
      "Project_id": "C6D9AEC2-18DF-0404-0FE6-AAB659A32E0F",
      "SalaryName": "银盾续年度销售佣金",
      "SalaryType": "业绩佣金",
      "commission": 93373.27,
    },
    {
      "Project_id": "E55EC426-65E2-2AD5-4AA7-9B821396C1F4",
      "SalaryName": "银盾首年度辅导奖金",
      "SalaryType": "业绩佣金",
      "commission": 93373.27,
    },
    {
      "Project_id": "F9E5ED14-7248-A5D7-490D-651399E814A6",
      "SalaryName": "银盾续年度辅导奖金",
      "SalaryType": "业绩佣金",
      "commission": 20698.46,
    },
    {
      "Project_id": "DB5B8AB9-B904-BA9D-F6DC-F1E7FD4A60DA",
      "SalaryName": "银盾管理奖金-首年度绩效奖金",
      "SalaryType": "业绩佣金",
      "commission": 348359.37,
    },
    {
      "Project_id": "0F70B51D-C7D6-316D-8EDC-CFBC7A5D4551",
      "SalaryName": "银盾管理奖金-续年度续缴奖金",
      "SalaryType": "业绩佣金",
      "commission": 20698.46,
    },
    {
      "Project_id": "6EDF61DF-7C16-2625-9A54-D5E03CA7E6B1",
      "SalaryName": "银盾推介奖金-同体系/跨体系推介奖金",
      "SalaryType": "业绩佣金",
      "commission": 20698.46,
    },
    {
      "Project_id": "DDCCD63D-EE47-5953-8CA0-CFAA83CB9A5E",
      "SalaryName": "银盾推介奖金-推介体系奖金",
      "SalaryType": "业绩佣金",
      "commission": 20698.46,
    },
    {
      "Project_id": "A09E7626-B77C-79A0-CC93-D929BCBB7B35",
      "SalaryName": "银盾管理奖金-业务合伙人特别管理奖金",
      "SalaryType": "业绩佣金",
      "commission": 348359.37,
    },
    {
      "Project_id": "91E8A0DD-8696-9964-CD35-AEBA6C8FDF19",
      "SalaryName": "其它税前加扣款",
      "SalaryType": "加扣款项",
      "commission": 17130.65,
    },
    {
      "Project_id": "45C0E205-653A-641B-1A35-C5C4148B1DA6",
      "SalaryName": "公司激励奖金",
      "SalaryType": "加扣款项",
      "commission": 17130.65,
    },
    {
      "Project_id": "FC664684-4CBB-E3EC-FEC4-02FDDCAB4A02",
      "SalaryName": "加码奖金",
      "SalaryType": "加扣款项",
      "commission": 17130.65,
    },
    {
      "Project_id": "105B9197-7B64-5AE6-AC47-C15AA857DDC5",
      "SalaryName": "季度奖金",
      "SalaryType": "加扣款项",
      "commission": 17130.65,
    },
    {
      "Project_id": "12C24EDF-83D7-081C-AE2C-085031C4DCAF",
      "SalaryName": "银盾在线佣金",
      "SalaryType": "加扣款项",
      "commission": 348359.37,
    }
    ]
    for(let i=0;i<this.salaryDetailsList.length;i++){
      if(this.salaryDetailsList[i]['Project_id'] === '54DB1075-AEF2-5F4C-ABDF-899F9EB66439'){
        this.fycSalesInfo = this.salaryDetailsList[i];
      }else if(this.salaryDetailsList[i]['Project_id'] === 'C6D9AEC2-18DF-0404-0FE6-AAB659A32E0F'){
        this.rycSalesInfo = this.salaryDetailsList[i];
      }else if(this.salaryDetailsList[i]['Project_id'] === 'E55EC426-65E2-2AD5-4AA7-9B821396C1F4'){
        this.fycTutorInfo = this.salaryDetailsList[i];
      }else if(this.salaryDetailsList[i]['Project_id'] === 'F9E5ED14-7248-A5D7-490D-651399E814A6'){
        this.rycTutorInfo = this.salaryDetailsList[i];
      }else if(this.salaryDetailsList[i]['Project_id'] === 'DB5B8AB9-B904-BA9D-F6DC-F1E7FD4A60DA'){
        this.fycMeritsInfo = this.salaryDetailsList[i];
      }else if(this.salaryDetailsList[i]['Project_id'] === '0F70B51D-C7D6-316D-8EDC-CFBC7A5D4551'){
        this.rycMeritsInfo = this.salaryDetailsList[i];
      }else if(this.salaryDetailsList[i]['Project_id'] === '6EDF61DF-7C16-2625-9A54-D5E03CA7E6B1'){
        this.recommendAward = this.salaryDetailsList[i];
      }else if(this.salaryDetailsList[i]['Project_id'] === 'DDCCD63D-EE47-5953-8CA0-CFAA83CB9A5E'){
       this.systemRecommendAward = this.salaryDetailsList[i];
      }else if(this.salaryDetailsList[i]['Project_id'] === 'A09E7626-B77C-79A0-CC93-D929BCBB7B35'){
       this.specialManagementAward = this.salaryDetailsList[i];
      }else if(this.salaryDetailsList[i]['Project_id'] === '91E8A0DD-8696-9964-CD35-AEBA6C8FDF19'){
       this.otherPreTaxDeduction = this.salaryDetailsList[i];
      }else if(this.salaryDetailsList[i]['Project_id'] === '45C0E205-653A-641B-1A35-C5C4148B1DA6'){
        this.IncentiveBonus = this.salaryDetailsList[i];
      }else if(this.salaryDetailsList[i]['Project_id'] === 'FC664684-4CBB-E3EC-FEC4-02FDDCAB4A02'){
       this.addWeight = this.salaryDetailsList[i];
      }else if(this.salaryDetailsList[i]['Project_id'] === '105B9197-7B64-5AE6-AC47-C15AA857DDC5'){
       this.quarterlyBonus = this.salaryDetailsList[i];
      }else if(this.salaryDetailsList[i]['Project_id'] === '12C24EDF-83D7-081C-AE2C-085031C4DCAF'){
       this.onlineAward = this.salaryDetailsList[i];
      }else{
        break;
      }
    }
  }

  lookTak(){
    this.takFlag = true;
  }

  /**
   * 
   * @param type
   * 1.跳转到保单
   * 2.跳转到体系
   * 3.跳转到备注
   */
  jumpToFirstYearSales(salaryName,type){
    this.router.navigate([`/salary_detail/${this.monDtlPeriod}`],{queryParams:{type:type,salaryName:salaryName}});
  }
}
