import { Component, OnInit } from '@angular/core';
import { MyService } from '../my.service';
import { LifeCommonService } from '../../common/life-common.service';
import { ActivatedRoute,Router } from "@angular/router";

@Component({
  selector: 'ydlife-salary',
  templateUrl: './salary.component.html',
  styleUrls: ['./salary.component.scss']
})
export class SalaryComponent implements OnInit {
  practitionerIdEG: any;
  practitionerId: any;
  payScaleInfos: Array<any>;
  //控制弹框
  toastDialog: boolean;
  toastInfo: any;
  tabList:Array<any>;
  selectedId:any = 1;
  constructor(private activatedRoute: ActivatedRoute,private myService: MyService,
     public lifeCommonService: LifeCommonService,
     private router: Router) { }

  ngOnInit() {
    const title = this.activatedRoute.snapshot.data[0]['title'];
    this.lifeCommonService.setTitle(title);
    this.practitionerIdEG = JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerIdEG'];
    this.practitionerId = JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId']
    this.payScaleListQuery();
    this.tabList = [
      {name:'2021年',id:1},
      {name:'历史薪资',id:2}
    ]
  }

  payScaleListQuery() {
    this.myService.payScaleListQuery({ practitionerIdEG: this.practitionerIdEG,practitionerId:this.practitionerId }).subscribe((res) => {
      if (res['success']) {
        this.payScaleInfos = res['data']['payScaleInfos'];
      } else {
        this.payScaleInfos = [];
      }
    })
  }


  selectTab(tabId){
    this.selectedId = tabId;
  }

  //进入薪资详情
  enterDetail(monDtlPeriod){
    this.router.navigate(['/salary_detail'],{ queryParams: { monDtlPeriod:monDtlPeriod} });
  }
}

