import { Component, OnInit } from '@angular/core';
import { MyService } from '../my.service';

@Component({
  selector: 'ydlife-suggestion',
  templateUrl: './suggestion.component.html',
  styleUrls: ['./suggestion.component.scss']
})
export class SuggestionComponent implements OnInit {
  alerts: Array<any> = [];
  placeholder: boolean;
  telflag: boolean;
  emailflag: boolean;
  customer: any;
  isNeedAlert: boolean;
  dialogInfo: any;
  name:string;
  constructor(private myService:MyService) { 
    this.customer = {
      customerId:JSON.parse(localStorage.getItem('lifeCustomerInfo')).customerId,
      practitionerId:JSON.parse(localStorage.getItem('lifeCustomerInfo')).practitionerId,
      phoneNo: JSON.parse(localStorage.getItem('lifeCustomerInfo'))['mobileNo'],
      email: '',
      commentText: '',
      plateform:2
    }
  }

  ngOnInit() {
    this.name = JSON.parse(localStorage.getItem('lifeCustomerInfo')).practitionerBasicInfo.name;
  }

  focus() {
    this.placeholder = false;
  }

  // 判断手机号是否有效
  telcheck(val) {
    const MOBILE_REGEXP = /^(1)\d{10}$/;
    this.telflag = MOBILE_REGEXP.test(val);
  }

  emailCheck(val) {
    const EMAIL_REGEXP = /^(\w-*\.*)+@(\w-?)+(\.\w{2,})+$/;
    this.emailflag = EMAIL_REGEXP.test(val);
  }

  submit() {
    this.telcheck(this.customer.phoneNo);
    this.emailCheck(this.customer.email);
    if ((this.telflag || this.emailflag) && this.customer.commentText !== '') {
      this.myService.customerComment(this.customer).subscribe(res => {
        if (res['success']) {
          this.openPopInfo('提交成功');
        } else {
          this.openPopInfo(res['message']);
        }
      });
    } else {
      if (this.customer.commentText === '') {
        this.openPopInfo('请详细描述一下您的问题，客服人员将会尽快与您联系。')
      } else {
        this.openPopInfo('请正确输入您的联系方式');
      }
      return false;
    }
  }

     // 打开弹窗
     openPopInfo(message) {
      this.isNeedAlert = true;
      this.dialogInfo = {
        title: null,
        content: { value: message, align: 'center' },
        footer: [{ value: '我知道了', routerLink: '', className: 'weui-dialog__btn_primary' }],
      };
    }
  
    // 关闭弹窗
    getPopInfo() {
      this.isNeedAlert = false;
    }
}
