import { Component, OnInit } from '@angular/core';
import { MyService } from '../my.service';
import { LifeCommonService } from '../../common/life-common.service';
import { Router } from "@angular/router";
@Component({
  selector: 'ydlife-my-business',
  templateUrl: './my-business.component.html',
  styleUrls: ['./my-business.component.scss']
})
export class MyBusinessComponent implements OnInit {
  businessList: Array<any>;
  constructor(private myService: MyService, public lifeCommonService: LifeCommonService, private router: Router) { }

  ngOnInit() {
    this.ownOpportunityQuery()

  }

  ownOpportunityQuery() {
    const brokerCustomerId = JSON.parse(localStorage.getItem('lifeCustomerInfo'))['customerId'];
    const brokerPractitionerId = JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId'];
    this.myService.ownOpportunityQuery({ customerId: brokerCustomerId, practitionerId: brokerPractitionerId }).subscribe((res) => {
      if (res['data']['ownOpportunityInfos']) {
        this.businessList = res['data']['ownOpportunityInfos'];
      } else {
        this.businessList = []
      }
    })
  }

  addBussiness() {
    this.router.navigate(['/business/0']);
  }
}
