import {Component, OnInit} from '@angular/core';
import {MyService} from '../my.service';
import { ActivatedRoute } from "@angular/router";

@Component({
  selector: 'ydlife-product-data',
  templateUrl: './product-data.component.html',
  styleUrls: ['./product-data.component.scss']
})
export class ProductDataComponent implements OnInit {
  productDataMenuLists: Array<any>;
  productId:any;
  planId:any;
  constructor(private myService:MyService,private activatedRoute: ActivatedRoute) {
    // 产品资料菜单
    this.productDataMenuLists = [
      {id: 1, iconPath: 'comIntro.png', name: '保司介绍', active: 1},
      {id: 2, iconPath: 'feature.png', name: '产品特色', active: 1},
      {id: 3, iconPath: 'item.png', name: '产品条款', active: 1},
      {id: 4, iconPath: 'priceRate.png', name: '费率现价表', active: 1},
      {id: 5, iconPath: 'notice.png', name: '投保须知', active: 1},
      {id: 6, iconPath: 'markting.png', name: '营销资料', active: 1},
      {id: 7, iconPath: 'e-insure.png', name: '微投保资料', active: 1},
      {id: 8, iconPath: 'commission.png', name: '公告佣金', active: 1},
      {id: 9, iconPath: 'other.png', name: '其它', active: 1}
    ];
  }

  ngOnInit() {
    this.productId = this.activatedRoute.snapshot.paramMap.get('id');
    this.planId = this.activatedRoute.snapshot.queryParams.planId?this.activatedRoute.snapshot.queryParams.planId:null;
    this.queryProductFile();
  }

  queryProductFile(){
    this.myService.queryProductFile({productId:this.productId,planId:this.planId}).subscribe((res)=>{
      console.log(res)
    })
  }
}
