import { Component, OnInit } from '@angular/core';
import { ActivatedRoute,Router } from "@angular/router";
import { LifeCommonService } from "../../../common/life-common.service";
import { MyService } from '../../my.service';
@Component({
  selector: 'ydlife-employee-submit',
  templateUrl: './employee-submit.component.html',
  styleUrls: ['./employee-submit.component.scss']
})
export class EmployeeSubmitComponent implements OnInit {
  hiringBasicInfoId:any;
  approveStatus:any;
  isNeedAlert: boolean;
  dialogInfo: any;
  constructor(private activatedRoute: ActivatedRoute,
    public lifeCommonService:LifeCommonService,
    private myService:MyService) { }

  ngOnInit() {
    sessionStorage.removeItem('viewApprovalInfo')
    const title = this.activatedRoute.snapshot.data[0]['title'];
    this.lifeCommonService.setTitle(title);
    this.hiringBasicInfoId = this.activatedRoute.snapshot.queryParams.hiringBasicInfoId?this.activatedRoute.snapshot.queryParams.hiringBasicInfoId:null;
    this.approveStatus = this.activatedRoute.snapshot.queryParams.status?this.activatedRoute.snapshot.queryParams.status:null;
    if(this.approveStatus == null || this.approveStatus == '-1'){
      this.hiringSubmit();
    }
  }

  hiringSubmit(){
    this.myService.hiringSubmit({hiringBasicInfoId:this.hiringBasicInfoId}).subscribe((res)=>{
      if(res['success']){

      }else{
        this.openPopInfo(res['message'])
      }
    })
  }

  // 打开弹窗
  openPopInfo(message) {
    this.isNeedAlert = true;
    this.dialogInfo = {
      title: null,
      content: { value: message, align: 'center' },
      footer: [{ value: '我知道了', routerLink: '', className: 'weui-dialog__btn_primary' }],
    };
  }

  // 关闭弹窗
  getPopInfo() {
    this.isNeedAlert = false;
  }

}
