import { Component, OnInit } from '@angular/core';
import { MyService } from "../my.service";

@Component({
  selector: 'ydlife-my-application',
  templateUrl: './my-application.component.html',
  styleUrls: ['./my-application.component.scss']
})
export class MyApplicationComponent implements OnInit {
  titleList:Array<any>;
  selectedId:number = 1;
  isShowClose:boolean = false;
  fileUploadItemList: Array<any>;
  constructor(private myService: MyService) { }

  ngOnInit() {
    this.titleList = [
      { id: 0, name: '经纪合同' },
      { id: 1, name: '欢迎信' },
      { id: 2, name: '公司制度' }
    ]
  }

  selectTab(id) {
    this.selectedId = id;
    if(this.selectedId==2){
      this.fileUpload(3, 0, 19, 'yd_download_file_type', 81);

    }
  }

  //  文件下载
  fileUpload(itemType, itemId, fileCategory, code, mdDropOptionId) {
    this.myService.filePath(itemType, itemId, fileCategory, code, mdDropOptionId).subscribe(res => {
      if (res['success']) {
        this.fileUploadItemList = res['data']['fileUploadItemList'];
      }
    });
  }
}
