import { Component, OnInit } from '@angular/core';
import { MyService } from "../my.service";
import { ActivatedRoute } from '@angular/router';
import { LifeCommonService } from '../../common/life-common.service';

@Component({
  selector: 'ydlife-announcement-detail',
  templateUrl: './announcement-detail.component.html',
  styleUrls: ['./announcement-detail.component.scss']
})
export class AnnouncementDetailComponent implements OnInit {
  announcementId: string;
  announcementLists: any;
  titleDeatil: string;
  constructor(private activateRoute: ActivatedRoute,
    private myService: MyService,
    public lifeCommonService: LifeCommonService) { }

  ngOnInit() {
    this.announcementId = this.activateRoute.snapshot.paramMap.get('id');
    this.announcementQuery(this.announcementId, null)
  }

  announcementQuery(id, announcementType) {
    this.myService.announcementQuery(id, announcementType).subscribe(res => {
      if (res['success']) {
        this.announcementLists = res['data']['announcementInfoList'][0];
        this.titleDeatil = this.lifeCommonService.delHtmlTag(this.announcementLists['title'])
      }
    });
  }


}
