import { Component, OnInit } from '@angular/core';
import { MyService } from '../my.service';

@Component({
  selector: 'ydlife-my-target',
  templateUrl: './my-target.component.html',
  styleUrls: ['./my-target.component.scss']
})
export class MyTargetComponent implements OnInit {
  //个人销售目标
  personalSalesReadonlyFlag: boolean;
  personalSalesActivityFlag: boolean;
  //增员目标编辑
  recruitsReadonlyFlag: boolean;
  recruitsActivityReadonlyFlag: boolean;

  searchType: any;
  //判断是否团队长
  isTeamleader: any;
  salesTargetMonths: Array<any>;
  practitionerId: any;
  //个人保费
  premium: any;
  //个人佣金
  commission: any;
  //个人件数
  pieces: any;
  //个人件平均保费
  pieceAveragePremium: any;
  recruitGoalForMonthList: Array<any>;
  numberRecruitsYear: number;
  numberMDRTYear: number;
  //控制弹框
  toastDialog: boolean;
  toastInfo: any;
  //月均销售活动量得分
  salesTargetActions: Array<any>;
  //增员活动量得分
  goalsActionsInfoList: Array<any>;
  salesTargetFlag: boolean = true;
  recruitingTargetFlag: boolean = true;
  money: any;
  constructor(private myService: MyService) { }

  ngOnInit() {
    this.searchType = 1;
    this.isTeamleader = sessionStorage.getItem('isTeamleader');
    this.practitionerId = JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId'];
    //初始化查个人销售目标
    this.salesTargetQuery(1);
  }

  //销售目标保存
  salesTargetSave(goalsType) {
    const salesTargetParam = {
      practitionerId: this.practitionerId,
      pieceAveragePremium: this.pieceAveragePremium,
      pieces: this.pieces,
      premium: Number(this.premium),
      commission: this.commission,
      salesTargetMonths: this.salesTargetMonths,
      goalsType: goalsType
    }
    for (let i = 0; i < this.salesTargetMonths.length; i++) {
      if (!this.salesTargetMonths[i]['premium'] && this.salesTargetMonths[i]['premium'] != 0) {
        this.toastDialog = true;
        this.toastInfo = {
          status: 1,
          msg: `请输入${this.salesTargetMonths[i]['monthNum']}月预计保费！`,
          timeout: 3000,
          align: 'center'
        };
        return;
      }
      if (!this.salesTargetMonths[i]['commission'] && this.salesTargetMonths[i]['commission'] != 0) {
        this.toastDialog = true;
        this.toastInfo = {
          status: 1,
          msg: `请输入${this.salesTargetMonths[i]['monthNum']}月预计佣金！`,
          timeout: 3000,
          align: 'center'
        };
        return;
      }
      if (!this.salesTargetMonths[i]['pieceAveragePremium'] && this.salesTargetMonths[i]['pieceAveragePremium'] != 0) {
        this.toastDialog = true;
        this.toastInfo = {
          status: 1,
          msg: `请输入${this.salesTargetMonths[i]['monthNum']}月件均保费！`,
          timeout: 3000,
          align: 'center'
        };
        return;
      }
    }
    this.myService.salesTargetSave(salesTargetParam).subscribe((res) => {
      if (res['success']) {
        this.toastDialog = true;
        this.toastInfo = {
          status: 1,
          msg: '保存成功！',
          timeout: 3000,
          align: 'center'
        };
        this.salesTargetQuery(goalsType);
      } else {
        this.toastDialog = true;
        this.toastInfo = {
          status: 1,
          msg: res['message'],
          timeout: 3000,
          align: 'center'
        };
      }
    })
  }

  //查询销售目标
  salesTargetQuery(goalsType) {
    this.myService.salesTargetQuery({ practitionerId: this.practitionerId, goalsType: goalsType }).subscribe((res) => {
      if (res['success']) {
        if (res['data']['salesTargetMonths'].length > 0) {
          this.salesTargetMonths = res['data']['salesTargetMonths'];
          this.salesTargetFlag = true;
          this.personalSalesReadonlyFlag = true;
          this.personalSalesActivityFlag = true;
        } else {
          this.initSalesTargetMonths();
          this.salesTargetFlag = false;
          this.personalSalesReadonlyFlag = false;
          this.personalSalesActivityFlag = false;
        }
        this.commission = res['data']['commission'];
        this.pieceAveragePremium = res['data']['pieceAveragePremium'];
        this.pieces = res['data']['pieces'];
        this.premium = res['data']['premium'];
        this.salesTargetActions = res['data']['salesTargetActions'];
      } else {
        this.commission = this.pieceAveragePremium = this.pieces = this.premium = null;
        this.salesTargetFlag = false;
        this.initSalesTargetMonths()
      }
    })
  }

  //修改平均值获取新的年度目标
  changePremium() {
    let premium = 0;
    let commission = 0;
    let pieceAveragePremium = 0;
    for (let i = 0; i < this.salesTargetMonths.length; i++) {
      premium += this.salesTargetMonths[i]['premium'];
      commission += this.salesTargetMonths[i]['commission'];
      pieceAveragePremium += this.salesTargetMonths[i]['pieceAveragePremium'];
    }
    this.premium = premium;
    this.commission = commission;
    this.pieceAveragePremium = pieceAveragePremium;
    if (this.premium && this.pieceAveragePremium) {
      this.pieces = Math.ceil(this.premium / this.pieceAveragePremium);
    }
  }

  //获取月销售平均值
  getMonthAverage(type) {
    // let premium, pieceAveragePremium, commission;
    // if (String(this.premium).indexOf(",") != -1) {
    //   premium = this.premium.replace(/,/g, '');
    // } else {
    //   premium = this.premium;
    // }
    // if (String(this.pieceAveragePremium).indexOf(",") != -1) {
    //   pieceAveragePremium = this.pieceAveragePremium.replace(/,/g, '');
    // } else {
    //   pieceAveragePremium = this.pieceAveragePremium
    // }
    // if (String(this.commission).indexOf(",") != -1) {
    //   commission = this.commission.replace(/,/g, '');
    // } else {
    //   commission = this.commission
    // }
    this.salesTargetMonths.forEach(item => {
      if (type === 'premium') {
        item.premium = Math.ceil(this.premium / 12);
      }
      if (type === 'commission') {
        item.commission = Math.ceil(this.commission / 12);
      }
      if (type === 'pieceAveragePremium') {
        item.pieceAveragePremium = this.pieceAveragePremium;
      }
      if (item.premium && Number(item.pieceAveragePremium)) {
        item.pieces = Math.ceil((this.premium / this.pieceAveragePremium) / 12);
      } else {
        item.pieces = 0;
      }
    });
    if (this.premium && Number(this.pieceAveragePremium)) {
      this.pieces = Math.ceil(this.premium / this.pieceAveragePremium);
    } else {
      this.pieces = 0;
    }
  }

  //月活动量保存
  salesTargetMonthSave(goalsType) {
    const param = {
      practitionerId: this.practitionerId,
      salesTargetActionsList: this.salesTargetActions,
      goalsType: goalsType
    }
    this.myService.salesTargetMonthSave(param).subscribe((res) => {
      if (res['success']) {
        this.toastDialog = true;
        this.toastInfo = {
          status: 1,
          msg: '保存成功！',
          timeout: 3000,
          align: 'center'
        };
        this.salesTargetQuery(goalsType);
      } else {
        this.toastDialog = true;
        this.toastInfo = {
          status: 1,
          msg: res['message'],
          timeout: 3000,
          align: 'center'
        };
      }
    })
  }

  //增员目标保存
  potentialGoalsSetting() {
    const recruitingParam = {
      practitionerId: this.practitionerId,
      numberRecruitsYear: this.numberRecruitsYear,
      numberMDRTYear: this.numberMDRTYear,
      recruitGoalForMonthList: this.recruitGoalForMonthList
    }
    this.myService.potentialGoalsSetting(recruitingParam).subscribe((res) => {
      if (res['success']) {
        this.toastDialog = true;
        this.toastInfo = {
          status: 1,
          msg: '保存成功！',
          timeout: 3000,
          align: 'center'
        };
        this.potentialGoalsQuery();
      } else {
        this.toastDialog = true;
        this.toastInfo = {
          status: 1,
          msg: res['message'],
          timeout: 3000,
          align: 'center'
        };
      }
    })
  }

  //增员目标查询接口
  potentialGoalsQuery() {
    this.myService.potentialGoalsQuery({ practitionerId: this.practitionerId }).subscribe((res) => {
      if (res['success']) {
        this.numberRecruitsYear = res['data']['numberRecruitsYear'];
        this.numberMDRTYear = res['data']['numberMDRTYear'];
        if (res['data']['recruitGoalForMonthList'].length > 0) {
          this.recruitGoalForMonthList = res['data']['recruitGoalForMonthList'];
          this.recruitingTargetFlag = true;
          this.recruitsReadonlyFlag = true;
        } else {
          this.initRecruitGoalForMonthList();
          this.recruitingTargetFlag = false;
          this.recruitsReadonlyFlag = false;
        }
      } else {
        this.numberRecruitsYear = null;
        this.numberMDRTYear = null;
        this.recruitingTargetFlag = false;
        this.initRecruitGoalForMonthList();
      }
    })
  }

  //获取月平均增员数
  getMonthRecruitsAverage(type) {
    this.recruitGoalForMonthList.forEach(item => {
      if (type === 'Recruits') {
        item.numberRecruits = Math.ceil(this.numberRecruitsYear / 12);
      }
      if (type === 'MDRT') {
        item.numberMDRT = Math.ceil(this.numberMDRTYear / 12);
      }
    });
  }

  //获取总增员数
  changeMonthRecruit() {
    let numberRecruitsYear = 0;
    let numberMDRTYear = 0;
    for (let i = 0; i < this.recruitGoalForMonthList.length; i++) {
      numberRecruitsYear += this.recruitGoalForMonthList[i]['numberRecruits'];
      numberMDRTYear += this.recruitGoalForMonthList[i]['numberMDRT'];
    }
    this.numberRecruitsYear = numberRecruitsYear;
    this.numberMDRTYear = numberMDRTYear;
  }

  //增员活动量查询
  potentialGoalsActionsQuery() {
    this.myService.potentialGoalsActionsQuery({ practitionerId: this.practitionerId }).subscribe((res) => {
      if (res['success']) {
        if (res['data']['goalsActionsInfoList']) {
          this.goalsActionsInfoList = res['data']['goalsActionsInfoList'];
          this.recruitsActivityReadonlyFlag = true;
        } else {
          this.recruitsActivityReadonlyFlag = false;
          this.goalsActionsInfoList = [];
        }
      } else {
        this.goalsActionsInfoList = [];
        this.recruitsActivityReadonlyFlag = false;
      }
    })
  }

  //增员活动量更新
  potentialGoalsActionsUpdate() {
    const RecruitActionParam = {
      practitionerId: this.practitionerId,
      goalsActionsInfoList: this.goalsActionsInfoList
    }
    this.myService.potentialGoalsActionsUpdate(RecruitActionParam).subscribe((res) => {
      if (res['success']) {
        this.toastDialog = true;
        this.toastInfo = {
          status: 1,
          msg: '保存成功！',
          timeout: 3000,
          align: 'center'
        };
        this.potentialGoalsActionsQuery();
      } else {
        this.toastDialog = true;
        this.toastInfo = {
          status: 1,
          msg: res['message'],
          timeout: 3000,
          align: 'center'
        };
      }
    })
  }

  inputBlur() {
    window.scrollTo(0, 0)
  }

  //初始化增员目标
  initRecruitGoalForMonthList() {
    this.recruitGoalForMonthList = [
      { numberMDRT: null, numberRecruits: null, month: 1 },
      { numberMDRT: null, numberRecruits: null, month: 2 },
      { numberMDRT: null, numberRecruits: null, month: 3 },
      { numberMDRT: null, numberRecruits: null, month: 4 },
      { numberMDRT: null, numberRecruits: null, month: 5 },
      { numberMDRT: null, numberRecruits: null, month: 6 },
      { numberMDRT: null, numberRecruits: null, month: 7 },
      { numberMDRT: null, numberRecruits: null, month: 8 },
      { numberMDRT: null, numberRecruits: null, month: 9 },
      { numberMDRT: null, numberRecruits: null, month: 10 },
      { numberMDRT: null, numberRecruits: null, month: 11 },
      { numberMDRT: null, numberRecruits: null, month: 12 }
    ]
  }

  //初始化商机目标
  initSalesTargetMonths() {
    this.salesTargetMonths = [
      { premium: null, commission: null, pieces: null, pieceAveragePremium: null, monthNum: 1 },
      { premium: null, commission: null, pieces: null, pieceAveragePremium: null, monthNum: 2 },
      { premium: null, commission: null, pieces: null, pieceAveragePremium: null, monthNum: 3 },
      { premium: null, commission: null, pieces: null, pieceAveragePremium: null, monthNum: 4 },
      { premium: null, commission: null, pieces: null, pieceAveragePremium: null, monthNum: 5 },
      { premium: null, commission: null, pieces: null, pieceAveragePremium: null, monthNum: 6 },
      { premium: null, commission: null, pieces: null, pieceAveragePremium: null, monthNum: 7 },
      { premium: null, commission: null, pieces: null, pieceAveragePremium: null, monthNum: 8 },
      { premium: null, commission: null, pieces: null, pieceAveragePremium: null, monthNum: 9 },
      { premium: null, commission: null, pieces: null, pieceAveragePremium: null, monthNum: 10 },
      { premium: null, commission: null, pieces: null, pieceAveragePremium: null, monthNum: 11 },
      { premium: null, commission: null, pieces: null, pieceAveragePremium: null, monthNum: 12 }
    ]
  }
}
