import { Component, OnInit } from '@angular/core';
import { ActivatedRoute,Router } from "@angular/router";
import { MyService } from '../my.service';
@Component({
  selector: 'ydlife-customer-relation',
  templateUrl: './customer-relation.component.html',
  styleUrls: ['./customer-relation.component.scss']
})
export class CustomerRelationComponent implements OnInit {
  customerList:Array<any>;
  customerId:any;
  constructor(private activatedRoute: ActivatedRoute,private myService:MyService) { }

  ngOnInit() {
    this.customerId = this.activatedRoute.snapshot.queryParams.customerId?this.activatedRoute.snapshot.queryParams.customerId:null;
    this.queryCustomerInsuredList();
  }

  queryCustomerInsuredList(){
    this.myService.queryCustomerInsuredList({holderCustomerId:this.customerId,practitionerCustomerId:JSON.parse(localStorage.getItem('lifeCustomerInfo'))['customerId']}).subscribe((res)=>{
      if(res['success']){
          this.customerList = res['data']['list'];
      }
    })
  }
}
