import {Component, OnDestroy, OnInit} from '@angular/core';
import {AuthService} from "./auth/auth.service";
import {LifeCommonService} from "./common/life-common.service";
import {Subscription} from "rxjs/index";
declare var wx: any;
@Component({
  selector: 'app-root',
  templateUrl: './app.component.html',
  styleUrls: ['./app.component.scss']
})
export class AppComponent implements OnInit, OnDestroy {
  shareGuidePageEnable: boolean;
  subscription: Subscription;

  constructor(private authService: AuthService, private lifeCommonService: LifeCommonService) {
    this.subscription = lifeCommonService.shareStatus$.subscribe(status => {
      this.shareGuidePageEnable = status == '1';
    });
  }

  ngOnInit() {
    this.authService.obtainToken().subscribe(res => {
      if (res['success']) {
        localStorage.setItem('lifeToken', res['data']['token']);
        this.getWxConfig();
      }
    });
  }

  ngOnDestroy() {
    this.subscription.unsubscribe();
  }

  //  微信JS-SDK注册
  getWxConfig() {
    const url = encodeURIComponent(location.href.split('#')[0]);
    this.authService.wxConfig(url).subscribe(res => {
      const data = res['data'];
      wx.config({
        debug: false,
        appId: data.appId,
        timestamp: data.timestamp,
        nonceStr: data.nonceStr,
        signature: data.signature,
        jsApiList: data.jsApiList,
        beta: true
      });
    });
  }

}
