import { Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { environment } from '../../environments/environment';

@Injectable({
  providedIn: 'root'
})
export class MyService {
  constructor(private http: HttpClient) {
  }

  private API = environment.BACKEND_URL_CONFIG_VALUE;

  //  保存分享码
  shareCallBack(shareInfo) {
    const url = this.API + '/shareCallBack';
    return this.http
      .post(url, JSON.stringify(shareInfo));
  }

  //  文件下载
  filePath(itemType, itemId, fileCategory, code, mdDropOptionId) {
    const url = this.API + '/filePathQuery';
    return this.http
      .post(url, JSON.stringify({ itemType: itemType, itemId: itemId, fileCategory: fileCategory, code: code, mdDropOptionId: mdDropOptionId }));
  }

  //  重要公告
  announcementQuery(id, announcementTypeId) {
    const url = this.API + '/announcementQuery';
    return this.http
      .post(url, JSON.stringify({ id: id, announcementTypeId: announcementTypeId }));
  }

  //  产品海报
  posterQuery(paginationInfo) {
    const url = this.API + '/posterQuery';
    return this.http
      .post(url, JSON.stringify(paginationInfo));
  }

  //查业绩
  brokerInfoQuery(practitionerId) {
    const url = this.API + '/practitioner/practitionerInfoQuery';
    return this.http
      .post(url, JSON.stringify(practitionerId));
  }

  //热销产品
  recommendPlanQuery(param) {
    const url = this.API + '/recommendPlanQuery';
    return this.http
      .post(url, JSON.stringify(param));
  }

  //培训资料分类
  dropOptionsQuery(param) {
    const url = this.API + "/metadata/dropOptionsQuery";
    return this.http.post(url, JSON.stringify(param)).pipe(res => {
      return res;
    });
  }

  queryproductlistbytag(param) {
    const url = this.API + "/queryproductlistbytag";
    return this.http.post(url, JSON.stringify(param)).pipe(res => {
      return res;
    });
  }
}
