import { Component, OnInit } from '@angular/core';
import { LifeCommonService } from '../../common/life-common.service';
import { ActivatedRoute,Router } from "@angular/router";
import { MyService } from '../my.service';
import { ModalService, ToastService } from 'ng-zorro-antd-mobile';

@Component({
  selector: 'ydlife-salary-detail',
  templateUrl: './salary-detail.component.html',
  styleUrls: ['./salary-detail.component.scss']
})
export class SalaryDetailComponent implements OnInit {
  practitionerIdEG: any;
  practitionerId:any;
  payScaleInfos:Array<any>;
  takFlag:boolean = false;
  taxToastShow:boolean;
  otherToastShow:boolean;
  salaryDetailsList:Array<any>;
  //首年度销售佣金
  fycSalesInfo:any = null;
  //续年度销售佣金
  rycSalesInfo:any = null;
  //月度销售加码奖
  monthlySalesAddWeight:any = null;
  //独立经纪人展业津贴
  independentBrokerAllowance:any = null;
  //首年度直接销售佣金
  fycTutorInfo:any = null;
  //续年度直接销售佣金
  rycTutorInfo:any = null;
  //首年度绩效奖金/团队管理绩效达标奖金
  fycMeritsInfo:any = null;
  //续年度续缴奖
  rycMeritsInfo:any = null;
  //推介奖
  recommendAward:any = null;
  //体系推介奖
  systemRecommendAward:any = null;
  //特别管理奖
  specialManagementAward:any = null;
  //直接辅导岗位津贴
  directCounseling:any = null;
  //间接辅导岗位津贴
  indirectCounseling:any = null;
  //育成奖金
  breedingBonus:any = null;
  //其他税前加扣款
  otherPreTaxDeduction:any = null;
  //激励奖金
  IncentiveBonus:any = null;
  //加码奖金
  addWeight:any = null;
  //季度奖
  quarterlyBonus:any = null;
  //银盾在线奖
  onlineAward:any = null;
  years:any;
  month:any;
  agent_id:any;
  //abc佣奖总和
  totalCommission:string;
  //扣款项
  deduction:string;
  //本期应税所得-》含税佣金合计
  sumcommission:number;
  //年度累计应税所得 -> 累计税前收入
  total_commission:number;
   //累计应扣所得税-> 累计应缴税额
   total_personal_tax:number;
  //本期应扣所得税 -> 本月应缴个人所得税
  personal_tax:number;
  //累计已扣所得税 -> 累计已缴税额
  total_paid:number;
  //本期实领
  after_tax_comis:number;
  //其他加扣款问号
  otherTaxFlag:boolean = false;
  abc:number;
  isBasic:any;
  constructor(private _toast: ToastService,public lifeCommonService: LifeCommonService,
    private activatedRoute: ActivatedRoute,
    private router:Router,
    private myService:MyService) { }

  ngOnInit() {
    this.practitionerIdEG = JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerIdEG'];
    this.practitionerId = JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId']
    this.payScaleListQuery();
    this.years = this.activatedRoute.snapshot.queryParams.years?this.activatedRoute.snapshot.queryParams.years:null;
    this.month = this.activatedRoute.snapshot.queryParams.month?this.activatedRoute.snapshot.queryParams.month:null;
    this.agent_id = this.activatedRoute.snapshot.queryParams.agent_id?this.activatedRoute.snapshot.queryParams.agent_id:null;
    this.isBasic = this.activatedRoute.snapshot.queryParams.isBasic?this.activatedRoute.snapshot.queryParams.isBasic:null;
    this.lifeCommonService.setTitle(`${this.years}年本期实发佣金`);
    this.querySalaryDetail(null);
    
  }

  querySalaryDetail(type){
    if(type!=null){
      for(let i=0;i<this.payScaleInfos.length;i++){
          if((this.payScaleInfos[i]['years'] == this.years) && ( Number(this.payScaleInfos[i]['month']) == this.month)){
            //上一期
            if(type=='pre'){
              // if(i==this.payScaleInfos.length-1){
              //   const toast = ToastService.show('已到第一期薪资！', 0);
              //   setTimeout(() => {
              //     ToastService.hide();
              //   }, 3000);
              //   return;
              // }
              if(this.payScaleInfos[i+1]['month'] <5 && this.years == 2021){
                if(this.payScaleInfos[i+1]['pdfOssPath']){
                    window.open(this.payScaleInfos[i+1]['pdfOssPath']);
                  }else{
                    const toast = ToastService.show('暂无薪资单！', 0);
                    setTimeout(() => {
                      ToastService.hide();
                    }, 3000);
                    return;
                  }
              }else{
                this.month = this.payScaleInfos[i+1]['month'];
                this.years = this.payScaleInfos[i+1]['years'];
                this.isBasic = this.payScaleInfos[i+1]['isBasic'];
                this.lifeCommonService.setTitle(`${this.years}年${this.month}月本期实发佣金`);
                this.initSalay();
              }
              break;
            }
            //下一期
            if(type == 'next'){
              if(i == 0){
                const toast = ToastService.show('已到最后一期薪资！', 0);
                setTimeout(() => {
                  ToastService.hide();
                }, 3000);
                return;
              }
              this.month = this.payScaleInfos[i-1]['month'];
              this.years = this.payScaleInfos[i-1]['years'];
              this.isBasic = this.payScaleInfos[i-1]['isBasic'];
              this.lifeCommonService.setTitle(`${this.years}年${this.month}月本期实发佣金`);
              this.initSalay();
              break;
            }
          }
        
      }
      
    }
    this.router.navigate(['/salary_detail'],{ queryParams: { years:this.years,month:this.month,agent_id:this.agent_id,isBasic:this.isBasic},replaceUrl: true});
    const param = {
      years:this.years,
      month:this.month,
      agent_id:this.agent_id,
      practitionerId:this.practitionerId,
      isBasic:this.isBasic
    }
    this.myService.querySalaryDetail(param).subscribe((res)=>{
      this.totalCommission = res['data']['abc'];
      this.deduction = res['data']['d'];
      this.salaryDetailsList = res['data']['list'];
      if(this.salaryDetailsList && this.salaryDetailsList.length >0){
        for(let i=0;i<this.salaryDetailsList.length;i++){
          //本期应税所得
          this.sumcommission = this.salaryDetailsList[0]['sumcommission'];
          //年度累计应税所得
          this.total_commission = this.salaryDetailsList[0]['total_commission'];
          //累计应扣所得税
          this.total_personal_tax = this.salaryDetailsList[0]['total_personal_tax'];
          //累计已扣所得税
          this.total_paid = this.salaryDetailsList[0]['total_paid'];
          //本期应扣所得税
          this.personal_tax = this.salaryDetailsList[0]['personal_tax'];
          this.after_tax_comis = this.salaryDetailsList[0]['after_tax_comis'];
          if(this.salaryDetailsList[i]['project_id'] === '54DB1075-AEF2-5F4C-ABDF-899F9EB66439' || this.salaryDetailsList[i]['salaryCode'] == 'A-001'){
            this.fycSalesInfo = this.salaryDetailsList[i];
          }else if(this.salaryDetailsList[i]['project_id'] === 'C6D9AEC2-18DF-0404-0FE6-AAB659A32E0F' || this.salaryDetailsList[i]['salaryCode'] == 'A-002'){
            this.rycSalesInfo = this.salaryDetailsList[i];
          }else if(this.salaryDetailsList[i]['salaryCode'] === 'A-003'){
            this.monthlySalesAddWeight = this.salaryDetailsList[i];
          }else if(this.salaryDetailsList[i]['salaryCode'] === 'A-004'){
            this.independentBrokerAllowance = this.salaryDetailsList[i];
          }else if(this.salaryDetailsList[i]['project_id'] === 'E55EC426-65E2-2AD5-4AA7-9B821396C1F4' || this.salaryDetailsList[i]['salaryCode'] === 'B-001'){
            this.fycTutorInfo = this.salaryDetailsList[i];
          }else if(this.salaryDetailsList[i]['project_id'] === 'F9E5ED14-7248-A5D7-490D-651399E814A6' || this.salaryDetailsList[i]['salaryCode'] === 'B-002'){
            this.rycTutorInfo = this.salaryDetailsList[i];
          }else if(this.salaryDetailsList[i]['project_id'] === 'DB5B8AB9-B904-BA9D-F6DC-F1E7FD4A60DA' ||  this.salaryDetailsList[i]['salaryCode'] === 'B-006'){
            this.fycMeritsInfo = this.salaryDetailsList[i];
          }else if(this.salaryDetailsList[i]['project_id'] === '0F70B51D-C7D6-316D-8EDC-CFBC7A5D4551' ||  this.salaryDetailsList[i]['salaryCode'] === 'B-007'){
            this.rycMeritsInfo = this.salaryDetailsList[i];
          }else if(this.salaryDetailsList[i]['salaryCode'] === 'B-008'){
            this.directCounseling = this.salaryDetailsList[i];
          }else if(this.salaryDetailsList[i]['salaryCode'] === 'B-009'){
            this.indirectCounseling = this.salaryDetailsList[i];
          }else if (this.salaryDetailsList[i]['salaryCode'] === 'B-010'){
            this.breedingBonus =  this.salaryDetailsList[i];
          }else if(this.salaryDetailsList[i]['project_id'] === '6EDF61DF-7C16-2625-9A54-D5E03CA7E6B1' || this.salaryDetailsList[i]['salaryCode'] === 'B-004'){
            this.recommendAward = this.salaryDetailsList[i];
          }else if(this.salaryDetailsList[i]['project_id'] === 'DDCCD63D-EE47-5953-8CA0-CFAA83CB9A5E' || this.salaryDetailsList[i]['salaryCode'] === 'B-005'){
           this.systemRecommendAward = this.salaryDetailsList[i];
          }else if(this.salaryDetailsList[i]['project_id'] === 'A09E7626-B77C-79A0-CC93-D929BCBB7B35' || this.salaryDetailsList[i]['project_id'] === '871C458C-CF54-F2A6-589F-EFEE1EE16B25' || this.salaryDetailsList[i]['salaryCode'] === 'B-003'){
           this.specialManagementAward = this.salaryDetailsList[i];
          }else if(this.salaryDetailsList[i]['project_id'] === '91E8A0DD-8696-9964-CD35-AEBA6C8FDF19' || this.salaryDetailsList[i]['salaryCode'] === 'C-002'){
           this.otherPreTaxDeduction = this.salaryDetailsList[i];
          }else if(this.salaryDetailsList[i]['project_id'] === '45C0E205-653A-641B-1A35-C5C4148B1DA6' || this.salaryDetailsList[i]['salaryCode'] === 'C-001'){
            this.IncentiveBonus = this.salaryDetailsList[i];
          }else if(this.salaryDetailsList[i]['project_id'] === 'FC664684-4CBB-E3EC-FEC4-02FDDCAB4A02' || this.salaryDetailsList[i]['salaryCode'] === 'C-003'){
           this.addWeight = this.salaryDetailsList[i];
          }else if(this.salaryDetailsList[i]['project_id'] === '105B9197-7B64-5AE6-AC47-C15AA857DDC5' || this.salaryDetailsList[i]['salaryCode'] === 'C-004'){
           this.quarterlyBonus = this.salaryDetailsList[i];
          }else if(this.salaryDetailsList[i]['project_id'] === '12C24EDF-83D7-081C-AE2C-085031C4DCAF' || this.salaryDetailsList[i]['salaryCode'] === 'C-005'){
           this.onlineAward = this.salaryDetailsList[i];
          }else{
            break;
          }
        }
      }
    })
  }

  lookTak(){
    this.takFlag = true;
  }

  /**
   * 
   * @param type
   * 1.跳转到保单
   * 2.跳转到体系
   * 3.跳转到备注
   * 4.跳转到银盾在线
   */
  jumpToFirstYearSales(salaryName,type,salaryType){
    if(this.isBasic == 1){
      const toast = ToastService.show('手动录入的薪资单，暂时不能查看详情！', 0);
      setTimeout(() => {
        ToastService.hide();
      }, 3000);
      return;
    }else{
      this.router.navigate([`/salary_detail/${salaryType}`],{queryParams:{type:type,salaryName:salaryName,years:this.years,month:this.month,agent_id:this.agent_id}});
    }
  }

  //薪资单列表-》用来判断上一期下一期的加减
  payScaleListQuery() {
    this.myService.payScaleListQuery({practitionerId:this.practitionerId,isHistory: 2}).subscribe((res) => {
      if (res['success']) {
        this.payScaleInfos = res['data']['payScaleInfos'];
      }
    })
  }

  //初始化佣奖类型
  initSalay(){
    this.fycSalesInfo = this.rycSalesInfo = this.fycTutorInfo = this.rycTutorInfo = this.fycMeritsInfo = 
    this.rycMeritsInfo=  this.recommendAward= this.systemRecommendAward = this.specialManagementAward= 
    this.otherPreTaxDeduction = this.IncentiveBonus = this.addWeight = this.quarterlyBonus= this.onlineAward= 
    this.monthlySalesAddWeight = this.independentBrokerAllowance =this.directCounseling = this.indirectCounseling=
    this.breedingBonus =  null;
  }

  goBack(){
    history.go(-1);
  }
}
