import { AfterContentInit, Component, OnDestroy, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { MyService } from '../my.service';
declare var rrweb:any;

@Component({
  selector: 'ydlife-e-notice-sign',
  templateUrl: './e-notice-sign.component.html',
  styleUrls: ['./e-notice-sign.component.scss']
})
export class ENoticeSignComponent implements OnInit,OnDestroy,AfterContentInit {
  timerId:any;
  events:Array<any>;
  pageInfo = {
    type:6,
    name:'客户告知书同意并签署页面ceshi '
  }
  constructor(private router:Router,private myService:MyService) { }

  ngOnInit() {

  }
  ngAfterContentInit(): void {
    this.creatRecord();
    this.timerId = setInterval(()=>{
      if(this.events.length>2){
        this.saveRecord()
      }
    },10 * 1000);
  }

  ngOnDestroy(): void {
    clearInterval(this.timerId)
  }

  creatRecord(){
    let _this = this;
    _this.events = [];
    rrweb.record({
      emit(event){
        // 将evene存入events数组中
        _this.events.push(event);
      },
      recordCanvas: true
    });
  }
  saveRecord(){
    this.myService.rrwebInfo(this.events,this.pageInfo).subscribe(res=>{
      this.creatRecord()
    })
  }
  agree(){
    this.saveRecord();
    this.router.navigate(['/eNoticeSignature'],{ queryParams: { type:'eNotice'} })
  }

}
