import { NgModule } from '@angular/core';
import { Routes, RouterModule } from '@angular/router';
import { MyCenterHomeComponent } from './my-center-home/my-center-home.component';
import { AuthGuard } from '../auth/auth.guard';
import { MkMaterialComponent } from './mk-material/mk-material.component';
import { MkMaterialDetailComponent } from './mk-material-detail/mk-material-detail.component';
import { FileUploadComponent } from './file-upload/file-upload.component';
import { ImportantAnnouncementComponent } from './important-announcement/important-announcement.component';
import { SalesDetailComponent } from './sales-detail/sales-detail.component';
import { AnnouncementDetailComponent } from './announcement-detail/announcement-detail.component';
import { MyBusinessComponent } from './my-business/my-business.component';
import { MyBusinessDetailComponent } from './my-business-detail/my-business-detail.component';
import { SalesRankComponent } from './sales-rank/sales-rank.component';
import { TeamRankComponent } from './team-rank/team-rank.component';
import { RecruitingComponent } from './recruiting/recruiting.component';
import { RecruitingDetailComponent } from './recruiting-detail/recruiting-detail.component';
import { ThanksComponent } from './thanks/thanks.component';
import { MySettingComponent } from './my-setting/my-setting.component';
import { MySettingDetailComponent } from './my-setting-detail/my-setting-detail.component';
import { MyNewsComponent } from './my-news/my-news.component';
import { MyTargetComponent } from "./my-target/my-target.component";
import { TeamPanelComponent } from './team-panel/team-panel.component';
import { TeamSalesScoreComponent } from './team-sales-score/team-sales-score.component';
import { ScoreDetailsComponent } from './score-details/score-details.component';
import { BusinessCardComponent } from "./business-card/business-card.component";
import { OrderDetailComponent } from './order-detail/order-detail.component';
import { SalaryComponent } from './salary/salary.component';
import { TodoListComponent } from './todo-list/todo-list.component';
import { AddTaskComponent } from './add-task/add-task.component';
import { MedicalServiceComponent } from './medical-service/medical-service.component';
import { InvitationComponent } from './application-process/invitation/invitation.component';
import { RegisterComponent } from './application-process/register/register.component';
import { EmployeeInfoComponent } from './application-process/employee-info/employee-info.component';
import { EmployeeBasicInfoComponent } from './application-process/employee-basic-info/employee-basic-info.component';
import { WorkExperienceComponent } from './application-process/work-experience/work-experience.component';
import { PersonalPhotosComponent } from './application-process/personal-photos/personal-photos.component';
import { EmployeeIdCardComponent } from './application-process/employee-id-card/employee-id-card.component';
import { EmployeeEducationComponent } from './application-process/employee-education/employee-education.component';
import { PersonalStatementComponent } from './application-process/personal-statement/personal-statement.component';
import { SignatureComponent } from './application-process/signature/signature.component';
import { EmployeeSubmitComponent } from './application-process/employee-submit/employee-submit.component';
import { BankCardComponent } from './application-process/bank-card/bank-card.component';
import { MemberDetailComponent } from './member-detail/member-detail.component';
import { ApprovalListComponent } from './approval-list/approval-list.component';
import { ApprovalCommentsComponent } from './approval-comments/approval-comments.component';
import { ApprovalResultListComponent } from './approval-result-list/approval-result-list.component';
import { MyApplicationComponent } from './my-application/my-application.component';
import { SuggestionComponent } from './suggestion/suggestion.component';
import { EmployeeSalaryComponent } from './application-process/employee-salary/employee-salary.component';
import { HistoricalRankComponent } from './historical-rank/historical-rank.component';
import { TeamAreaPanelComponent } from './team-area-panel/team-area-panel.component';
import { ArticleComponent } from './article/article.component';
import { ArticleDetailComponent } from './article-detail/article-detail.component';
import { ArticleReadComponent } from './article-read/article-read.component';
import { SalaryDetailComponent } from './salary-detail/salary-detail.component';
import { SalaryFirstYearComponent } from './salary-first-year/salary-first-year.component';

const myRoutes: Routes = [
  { path: '', component: MyCenterHomeComponent, canActivate: [AuthGuard], data: [{ title: '银盾保险经纪 - 工作台' }] },
  { path: 'material', component: MkMaterialComponent, canActivate: [AuthGuard] },
  { path: 'material/:itemId', component: MkMaterialDetailComponent, canActivate: [AuthGuard] },
  { path: 'fileUpload', component: FileUploadComponent, canActivate: [AuthGuard], data: [{ type: 'fileUpload' }] },
  { path: 'training', component: FileUploadComponent, canActivate: [AuthGuard], data: [{ type: 'training' }] },
  { path: 'importantAnnouncement', component: ImportantAnnouncementComponent, canActivate: [AuthGuard] },
  { path: 'salesDetail', component: SalesDetailComponent, canActivate: [AuthGuard] },
  { path: 'importantAnnouncement/:id', component: AnnouncementDetailComponent, canActivate: [AuthGuard] },
  { path: 'business', component: MyBusinessComponent, canActivate: [AuthGuard],data:[{type:'business'}] },
  { path: 'linkbusiness', component: MyBusinessComponent, canActivate: [AuthGuard],data:[{type:'linkbusiness'}] },
  { path: 'business/:id', component: MyBusinessDetailComponent, canActivate: [AuthGuard] },
  { path: 'rank', component: SalesRankComponent, canActivate: [AuthGuard] },
  { path: 'teamRank', component: TeamRankComponent, canActivate: [AuthGuard] },
  { path: 'recruiting', component: RecruitingComponent, canActivate: [AuthGuard] ,data:[{type:'recruiting'}]},
  { path: 'linkrecruiting', component: RecruitingComponent, canActivate: [AuthGuard] ,data:[{type:'linkrecruiting'}]},
  { path: 'recruiting/:id', component: RecruitingDetailComponent, canActivate: [AuthGuard] },
  { path: 'thanks', component: ThanksComponent, canActivate: [AuthGuard] },
  { path: 'setting', component: MySettingComponent, canActivate: [AuthGuard] },
  { path: 'setting/:uploadType', component: MySettingDetailComponent, canActivate: [AuthGuard] },
  { path: 'news', component: MyNewsComponent, canActivate: [AuthGuard] },
  { path: 'target', component: MyTargetComponent, canActivate: [AuthGuard] },
  { path: 'teamPanel', component: TeamPanelComponent, canActivate: [AuthGuard] },
  { path: 'teamPanel/:type', component: TeamSalesScoreComponent, canActivate: [AuthGuard] },
  { path: 'scoreDeatil', component: ScoreDetailsComponent, canActivate: [AuthGuard] },
  { path: 'scoreDeatil/:practitionerId', component: ScoreDetailsComponent, canActivate: [AuthGuard] },
  { path: 'businessCard', component: BusinessCardComponent, canActivate: [AuthGuard] },
  { path: 'orderDetail', component: OrderDetailComponent, canActivate: [AuthGuard] },
  { path: 'salary', component: SalaryComponent, canActivate: [AuthGuard],data:[{title:'我的薪资'}] },
  { path: 'todo', component: TodoListComponent, canActivate: [AuthGuard] },
  { path: 'addtask',component:AddTaskComponent,canActivate:[AuthGuard]},
  { path: 'medical_service',component:MedicalServiceComponent,canActivate:[AuthGuard]},
  { path: 'inviter' ,component:InvitationComponent,canActivate:[AuthGuard],data:[{type:'inviter',title: '邀请函'}]},
  { path: 'invitees' ,component:InvitationComponent,data:[{type:'invitees',title: '邀请函'}]},
  { path: 'register' ,component:RegisterComponent,data: [{ title: '注册信息' }]},
  { path: 'employee_info',component:EmployeeInfoComponent,data: [{ title: '银盾经纪人报聘' }]},
  { path: 'employee_basic_info',component:EmployeeBasicInfoComponent,data: [{ title: '银盾经纪人报聘' }] },
  { path: 'work_experience',component:WorkExperienceComponent,data: [{ title: '银盾经纪人报聘' }] },
  { path: 'personal_photos',component:PersonalPhotosComponent,data: [{ title: '银盾经纪人报聘' }] },
  { path: 'employee_id_card',component:EmployeeIdCardComponent,data: [{ title: '银盾经纪人报聘' }] },
  { path: 'employee_education',component:EmployeeEducationComponent,data: [{ title: '银盾经纪人报聘' }] },
  { path: 'bank_card',component:BankCardComponent,data:[{title:'银盾经纪人报聘'}]},
  { path: 'employee_salary',component:EmployeeSalaryComponent,data: [{ title: '银盾经纪人报聘' }] },
  { path: 'personal_statement',component:PersonalStatementComponent,data: [{ type:'personal_statement',title: '银盾经纪人报聘' }] },
  { path: 'contract',component:PersonalStatementComponent,data: [{ type:'contract',title: '银盾经纪人报聘' }] },
  { path: 'signature',component:SignatureComponent,data: [{ title: '银盾经纪人报聘' }]},
  { path: 'employee_submit',component:EmployeeSubmitComponent,data: [{ title: '已提交' }]},
  { path: 'member_detail/:practitionerId',component:MemberDetailComponent, canActivate: [AuthGuard]},
  { path: 'approval_list',component:ApprovalListComponent, data: [{ title: '审批列表' }],canActivate: [AuthGuard]},
  { path: 'approval_comments',component:ApprovalCommentsComponent,canActivate:[AuthGuard]},
  { path: 'approval_result_list',component:ApprovalResultListComponent,data: [{ title: '审批流程' }],canActivate:[AuthGuard]},
  { path: 'my_application',component:MyApplicationComponent,data: [{ title: '我的报聘' }],canActivate:[AuthGuard]},
  { path: 'suggestion',component:SuggestionComponent,data: [{ title: '问题反馈' }],canActivate:[AuthGuard]},
  { path: 'historical_rank', component: HistoricalRankComponent, canActivate: [AuthGuard] },
  { path: 'team_area',component:TeamAreaPanelComponent, canActivate: [AuthGuard]},
  { path: 'article/:mdDropOptionId', component:ArticleComponent},
  { path: 'articleDetail/:id',component:ArticleDetailComponent},
  { path: 'article_read/:id',component:ArticleReadComponent,canActivate:[AuthGuard]},
  { path: 'salary_detail',component:SalaryDetailComponent,canActivate:[AuthGuard]},
  { path: 'salary_detail/:id',component:SalaryFirstYearComponent,canActivate:[AuthGuard]}
];

@NgModule({
  imports: [RouterModule.forChild(myRoutes)],
  exports: [RouterModule]
})
export class MyRoutingModule {
}
