import { Component, OnInit,ViewChild,ElementRef } from '@angular/core';
import { ActivatedRoute,Router } from "@angular/router";
import { MyService } from '../../my.service';
import { LifeCommonService } from "../../../common/life-common.service";
@Component({
  selector: 'ydlife-personal-statement',
  templateUrl: './personal-statement.component.html',
  styleUrls: ['./personal-statement.component.scss']
})
export class PersonalStatementComponent implements OnInit {
  @ViewChild('autofocusFlag') elementView: ElementRef;
  //判断是个人声明还是合同确认
  type:any;
  hiringBasicInfoId:any;
  dropOptionsInfoList:Array<any>;
  isNeedAlert: boolean;
  dialogInfo: any;
  autofocusFlag:boolean;
  dropOptionsInfoListParam:Array<any> = [];
  contractTermsList:Array<any>;
  everWork:string;
  //判断曾经报聘是否可点
  everWorkFlag:boolean = false;
  isShow: boolean;
  curTitle:any;
  curContract:any;
  curContractId:number;
  isAllAgree:boolean = false;
  contractTermsConfirmsListParm:Array<any>;
  constructor(private myService: MyService, 
    private activatedRoute: ActivatedRoute,
    public lifeCommonService: LifeCommonService,
    private router: Router) { }

  ngOnInit() {
    this.type = this.activatedRoute.snapshot.data[0]['type'];
    const title = this.activatedRoute.snapshot.data[0]['title'];
    this.lifeCommonService.setTitle(title);
    this.hiringBasicInfoId = this.activatedRoute.snapshot.queryParams.hiringBasicInfoId?this.activatedRoute.snapshot.queryParams.hiringBasicInfoId:null;
    if(this.type==="personal_statement"){
      this.dropOptionsQuery();
    }else{
      this.queryContractTerms();
    }
    this.queryWholeInfo(this.hiringBasicInfoId);
  }

  ngOnChanges(){

  }

  next(){
    if(this.type == 'personal_statement'){
      this.savePersonalStatements();
    }else if(this.type == 'contract'){
      this.saveContractTermsConfirms();
      if(!this.isAllAgree){
        this.openPopInfo('请详细阅读全部条款！')
        return;
      }
      this.router.navigate(['/signature'],{ queryParams: { hiringBasicInfoId:this.hiringBasicInfoId} });
    }
  }

  dropOptionsQuery(){
    this.myService.dropOptionsQuery({code:'EHiring_Personal_Statements'}).subscribe((res)=>{
      if(res['success']){
        this.dropOptionsInfoList = res['data']['dropMasterInfoList'][0]['dropOptionsInfoList'];
        this.dropOptionsInfoList.forEach((item)=>{
          item.status = 0;
          item.userInput = null;
        })
      }else{
        this.openPopInfo(res['message']);
      }
    })
  }

   // 打开弹窗
   openPopInfo(message) {
    this.isNeedAlert = true;
    this.dialogInfo = {
      title: null,
      content: { value: message, align: 'center' },
      footer: [{ value: '我知道了', routerLink: '', className: 'weui-dialog__btn_primary' }],
    };
  }

  //选择个人声明
  selectStatements(personalStatements){
    if( personalStatements.status ==1){
      personalStatements.status = 0;
    }else{
      personalStatements.status = 1;
    }
    if(personalStatements.id == '241'){
      if(personalStatements.status == 1){
        this.everWorkFlag = true;
        //点击曾经报聘输入报聘自动获取焦点
        setTimeout(() => {
          this.elementView.nativeElement.focus();
        }, 500);
      }else{
        this.everWork = null;
        this.everWorkFlag = false;
      }
      
    }
  }

  savePersonalStatements(){
    this.dropOptionsInfoListParam = [];
    for(let i=0;i<this.dropOptionsInfoList.length;i++){
      this.dropOptionsInfoList[i]['mdDropOptionName'] = this.dropOptionsInfoList[i]['dropOptionName'];
      this.dropOptionsInfoList[i]['mdDropOptionId'] = this.dropOptionsInfoList[i]['id'];
      if(this.dropOptionsInfoList[i]['id'] =='241'){
        this.dropOptionsInfoListParam.push({
          mdDropOptionName:this.dropOptionsInfoList[i]['dropOptionName'],
          mdDropOptionId:this.dropOptionsInfoList[i]['id'],
          status:this.dropOptionsInfoList[i]['status'],
          userInput:this.everWork?this.everWork:null
        })
      }else{
        this.dropOptionsInfoListParam.push({
          mdDropOptionName:this.dropOptionsInfoList[i]['dropOptionName'],
          mdDropOptionId:this.dropOptionsInfoList[i]['id'],
          status:this.dropOptionsInfoList[i]['status'],
          userInput:null
        })
      }
    }
    const param = {
      hiringBasicInfoId:this.hiringBasicInfoId,
      personalStatementList:this.dropOptionsInfoListParam
    }
    this.myService.savePersonalStatements(param).subscribe((res)=>{
      if(res['success']){
        this.router.navigate(['/contract'],{ queryParams: { hiringBasicInfoId:this.hiringBasicInfoId} });
      }else{
        this.openPopInfo(res['message']);
      }
    })
  }
  
  queryContractTerms(){
    this.myService.queryContractTerms().subscribe((res)=>{
      console.log(res)
      if(res['success']){
        this.contractTermsList = res['data']['contractTermsList'];
        this.contractTermsList.forEach((item)=>{
          item.confirmStatus = 0;
        })
      }
    })
  }

  // 关闭弹窗
  getPopInfo() {
    this.isNeedAlert = false;
  }

  readContract(contractItem){
    if( contractItem.confirmStatus ==1){
      contractItem.confirmStatus = 0;
    }else{
      this.isShow = true;
      this.curContract = contractItem.termNote;
      this.curTitle = contractItem.termName;
      this.curContractId = contractItem.id;
    }
    
  }

  //同意合同条款
  agree() {
    this.isShow = false;
    for(let i=0;i<this.contractTermsList.length;i++){
      if(this.curContractId == this.contractTermsList[i]['id']){
        this.contractTermsList[i]['confirmStatus'] = 1;
      }
    }
    this.isAllAgree = this.contractTermsList.every((item)=>{
      return item.confirmStatus == 1;
    })
  }

  saveContractTermsConfirms(){
    this.contractTermsConfirmsListParm = [];
    for(let i=0;i<this.contractTermsList.length;i++){
      this.contractTermsConfirmsListParm.push({
        contractTermId:this.contractTermsList[i]['id'],
        confirmStatus:this.contractTermsList[i]['confirmStatus']
      })
    }
    const param = {
      hiringBasicInfoId:this.hiringBasicInfoId,
      contractTermsConfirmsList:this.contractTermsConfirmsListParm
    }
   this.myService.saveContractTermsConfirms(param).subscribe((res)=>{
    if(res['success']){

    }else{
      this.openPopInfo(res['message']);
    }
   })
  }

  queryWholeInfo(hiringBasicInfoId){
    this.myService.queryWholeInfo({hiringBasicInfoId:hiringBasicInfoId}).subscribe((res)=>{
      if(res['success']){
        if(this.type==="personal_statement"){
          this.dropOptionsInfoList = res['data']['hiringPersonalStatementsList'];
          for(let i=0;i<this.dropOptionsInfoList.length;i++){
            this.dropOptionsInfoList[i]['dropOptionName'] = this.dropOptionsInfoList[i]['mdDropOptionName'];
            this.dropOptionsInfoList[i]['id'] = this.dropOptionsInfoList[i]['mdDropOptionId'];
            if(this.dropOptionsInfoList[i]['status'] == 1 && this.dropOptionsInfoList[i]['id']== '241'){
              this.everWorkFlag = true;
              this.everWork =  this.dropOptionsInfoList[i]['userInput'];
            }else{
              this.everWorkFlag = false;
            }
          }
        }
        if(this.type === 'contract'){
          let hiringContractTermsConfirmsList = res['data']['hiringContractTermsConfirmsList'];
          for(let i=0;i<hiringContractTermsConfirmsList.length;i++){
            for(let j=0;j<this.contractTermsList.length;j++){
              if(hiringContractTermsConfirmsList[i]['contractTermId'] == this.contractTermsList[j]['id']){
                this.contractTermsList[j]['confirmStatus'] = hiringContractTermsConfirmsList[i]['confirmStatus'];
              }
            }
          }
          this.isAllAgree = this.contractTermsList.every((item)=>{
            return item.confirmStatus == 1;
          })
        }
      }
    })
  }
}
