import { Component, OnInit } from '@angular/core';
import { MyService } from '../../my/my.service';
import { LifeCommonService } from '../../common/life-common.service';
import { Router,ActivatedRoute } from '@angular/router';
import { ModalService, ToastService } from 'ng-zorro-antd-mobile';

@Component({
  selector: 'ydlife-activity',
  templateUrl: './activity.component.html',
  styleUrls: ['./activity.component.scss']
})
export class ActivityComponent implements OnInit {
  titleList:Array<any>;
  mdDropOptionId:any;
  paginationInfo:any;
  activityList:Array<any>;
  totalPage:number;
  practitionerId:any;
  constructor(private myService:MyService,
    public lifeCommonService:LifeCommonService,
    private router:Router,
    private _modal: ModalService, 
    private _toast: ToastService,
    public activatedRoute: ActivatedRoute) {
    this.paginationInfo = {
      pageNum: 1,
      pageSize: 5
    }
  }

  ngOnInit() {
    this.mdDropOptionId = this.activatedRoute.snapshot.params['mdDropOptionId'];
    this.practitionerId = JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId'];
    this.dropOptionsQuery();
  }

  dropOptionsQuery() {
    this.myService.dropOptionsQuery({ code: "practitioner_sharing_type" })
      .subscribe((res) => {
        if (res["success"]) {
          this.titleList =res["data"]["dropMasterInfoList"][0]["dropOptionsInfoList"];
          if(this.mdDropOptionId!='null'){
            this.selectTab(this.mdDropOptionId)
          }else{
            this.mdDropOptionId = this.titleList[0]['id'];
            this.practitionerFileSharingList(null);
          }
        }
      });
  }

  selectTab(id) {
    this.mdDropOptionId = id;
    this.router.navigate(['/activity', this.mdDropOptionId], {replaceUrl: true});
    this.paginationInfo = {
      pageNum: 1,
      pageSize: 5
    }
    this.practitionerFileSharingList(null);
  }

  //文章查询列表
  practitionerFileSharingList(flag){
    const param = {
      mdDropOptionId:this.mdDropOptionId,
      practitionerFileShares:this.paginationInfo,
      practitionerId:this.practitionerId,
	  itemType:'2'
    }
    this.myService.practitionerFileSharingList(param).subscribe((res)=>{
      if(res['success']){
        if(flag == null){
          this.activityList = res['data']['practitionerFileShares']['list'];
        }else{
          this.activityList = this.activityList.concat(res['data']['practitionerFileShares']['list'])
        }
        this.paginationInfo.pageNum = res['data']['practitionerFileShares']['pageNum'];//当前页
        this.totalPage = res['data']['practitionerFileShares']['pages'];//总页数
      }else{

      }
    })
  }

  lookMore(){
    this.paginationInfo.pageNum ++;
    this.practitionerFileSharingList('flag');
  }

  //设置缓存并跳转到文章详情
  activityDetail(activityItem){
    this.router.navigate(['/activityDetail',activityItem.id]);
  }

  whoRead(activityItem){
    if(activityItem.num > 0){
      this.router.navigate(['/article_read',activityItem.id])
    }else{
      const toast = ToastService.show('暂时无人阅读您分享的文章！', 0);
      setTimeout(() => {
        ToastService.hide();
      }, 3000);
      return;
    }
  }
}
