import { AfterViewInit, Component, OnDestroy, OnInit } from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';
import { MyService } from '../my.service';
declare var rrweb:any;

@Component({
  selector: 'ydlife-joint-sale-detail',
  templateUrl: './joint-sale-detail.component.html',
  styleUrls: ['./joint-sale-detail.component.scss']
})
export class JointSaleDetailComponent implements OnInit,OnDestroy {
  unionSalesId:any;
  unionSalesPractitionerId:any;
  unionSalesInfo:any;
  unionSalesPractitionerInfos:Array<any>;
  timerId:any;
  events:Array<any> = [];
  pageInfo = {
    type:11,
    name:'联合销售同意并签署页面'
  }
  constructor(private myService:MyService,private route:ActivatedRoute,private router:Router) { }

  ngOnInit() {

    this.unionSalesId = this.route.snapshot.params['unionSalesId'];
    this.queryUnionSalesPractitionerList();
  }
  ngOnDestroy(): void {
    clearInterval(this.timerId)
  }

  creatRecord(){
    let _this = this;
    _this.events = [];
    rrweb.record({
      emit(event){
        // 将evene存入events数组中
        _this.events.push(event);
      },
      recordCanvas: true
    });
  }
  saveRecord(){
    this.myService.rrwebInfo(this.events,this.pageInfo).subscribe(res=>{
      this.creatRecord()
    })
  }

  queryUnionSalesPractitionerList(){
    this.myService.queryUnionSalesPractitionerList({unionSalesId:this.unionSalesId,isActive:1}).subscribe(res=>{
      if(res['success']){
        this.unionSalesInfo = res['data']['unionSalesInfo'];
        this.unionSalesPractitionerInfos = this.unionSalesInfo.unionSalesPractitionerInfos;
        const practitionerId = localStorage.getItem('lifeCustomerInfo')?JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId']:null;
        if(practitionerId){
          this.unionSalesInfo.signStatus = this.unionSalesPractitionerInfos.filter(item=>item.practitionerId == practitionerId).pop().signStatus
          this.unionSalesPractitionerId = this.unionSalesPractitionerInfos.filter(item=>item.practitionerId == practitionerId).pop().id;
          if(this.unionSalesInfo.signStatus=='1'){
            this.creatRecord();
            this.timerId = setInterval(()=>{
              if(this.events.length > 100){
                this.saveRecord()
              }
            },10 * 1000);
          }
        }
      }
    })
  }

  sign(){
    this.saveRecord();
    this.router.navigate(['/signature'],{queryParams:{type:'unionSaleSignature',unionSalesPractitionerId:this.unionSalesPractitionerId,unionSalesId:this.unionSalesId}})
  }

}
