import { Component, OnInit } from '@angular/core';
import { LifeCommonService } from '../../common/life-common.service';
import {MyService} from '../my.service';
import * as dayjs from 'dayjs'

@Component({
  selector: 'ydlife-todo-list',
  templateUrl: './todo-list.component.html',
  styleUrls: ['./todo-list.component.scss']
})
export class TodoListComponent implements OnInit {
  weekArr: Array<any>;
  taskList:Array<any> = [];
  taskTimeList:Array<any> = [];
  trackDate:string;
  state: any = {
    en: false,
    date: null,
    show: false,
    pickTime: false,
    now: new Date(),
    type: 'one',
    enterDirection: '',
    rowSize: 'normal',
    showShortcut: false,
    infinite: true,
    defaultValue: undefined,
    minDate: new Date(+new Date() - 5184000000),
    maxDate: new Date(+new Date() + 31536000000),
    onSelect: undefined,
  }
  constructor(public lifeCommonService: LifeCommonService,private myService:MyService) {
    this.taskTimeList = [
      {id:1,time:'8:00'},
      {id:2,time:'9:00'},
      {id:3,time:'10:00'},
      {id:4,time:'11:00'},
      {id:5,time:'12:00'},
      {id:6,time:'13:00'},
      {id:7,time:'14:00'},
      {id:8,time:'15:00'},
      {id:9,time:'16:00'},
      {id:10,time:'17:00'},
      {id:11,time:'18:00'},
      {id:12,time:'19:00'},
    ]
   }
  
  ngOnInit() {
    this.weekArr = this.lifeCommonService.makeDate();
    this.trackDate = dayjs().format('YYYY-MM-DD');
    this.queryScheduleTrackList();
    console.log(dayjs)
  }

  goBack(){
    history.go(-1)
  }

  selectDay(weekItem){
    for(let i=0;i<this.weekArr.length;i++){
      this.weekArr[i].selected = false;
      if(weekItem.day == this.weekArr[i]['day']){
        this.weekArr[i].selected = true;
        this.trackDate =  this.weekArr[i]['date'];
      }
    }
    this.queryScheduleTrackList();
  }

  initPara() {
    this.state = {
      ...this.state,
      ...{
        show: false,
        date: null,
        pickTime: false,
        now: new Date(),
        type: 'one',
        rowSize: 'normal',
        infinite: true,
        enterDirection: '',
        onSelect: undefined,
        showShortcut: false,
        defaultValue: undefined,
      }
    };
  }

  clickCalendar(){
    this.initPara();
    this.state.show = true;
    this.state.date = new Date();
  }

  triggerCancel() {
    this.state.show = false;
  }

  triggerConfirm(value) {
    const { startDate, endDate } = value;
    this.state = {
      ...this.state,
      show: false,
       startDate, 
       endDate 
    };
    this.triggerCancel();
    this.trackDate =dayjs(startDate).format('YYYY-MM-DD');
    console.log(this.trackDate)
    this.queryScheduleTrackList();
    this.weekArr = this.lifeCommonService.makeDate(startDate);
    console.log(this.weekArr)
  }

  queryScheduleTrackList(){
    this.myService.queryScheduleTrackList({practitionerId:'1',trackDate:this.trackDate}).subscribe((res)=>{
      if(res['success']){
        this.taskList = res['data'];
      }
    })
  }
}
