import { Component, OnInit } from '@angular/core';
import { ActivatedRoute, Router } from "@angular/router";
import { MyService } from '../my.service';
import { LifeCommonService } from '../../common/life-common.service';

@Component({
  selector: 'ydlife-team-sales-score',
  templateUrl: './team-sales-score.component.html',
  styleUrls: ['./team-sales-score.component.scss']
})
export class TeamSalesScoreComponent implements OnInit {
  showType: any;
  practitionerId: any;
  subordinateSystemName: any;
  playerSalesActivityInfo: Array<any>;
  selectedSalseItem: any;
  salesPerformanceForecastInfos: Array<any>;
  personalList:Array<any>;
  teamMemberList:Array<any>;
  teamList:Array<any>;
  sortType:number = 2;
  constructor(private activateRoute: ActivatedRoute, private router: Router,
    private myService: MyService, public lifeCommonService: LifeCommonService) { }

  ngOnInit() {
    this.practitionerId = JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId'];
    //判断显示销售得分还是销售预测
    this.showType = this.activateRoute.snapshot.paramMap.get('type');
    if (this.showType === 'teamSalesScore') {
      this.queryPEPScore();
      this.subordinateSystemName = JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerBasicInfo']['subordinateName']
    }
    if (this.showType === 'forecast') {
      this.salesPerformanceForecastListQuery('m')
      this.subordinateSystemName = JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerBasicInfo']['subordinateName']
    }
    if(this.showType === 'memberList'){
      this.queryTeamMemberDetail();
    }
  }

  //获取成员销售活动量得分
  // playerSalesActivityQuery() {
  //   this.myService.playerSalesActivityQuery({ practitionerId: this.practitionerId }).subscribe((res) => {
  //     if (res['success']) {
  //       this.playerSalesActivityInfo = res['data']['playerSalesActivityInfo']
  //     }
  //   })
  // }

  salesPerformanceForecastListQuery(type) {
    this.selectedSalseItem = type;
    const param = {
      practitionerId: this.practitionerId,
      time: type
    }
    this.myService.salesPerformanceForecastListQuery(param).subscribe((res) => {
      if (res['success']) {
        this.salesPerformanceForecastInfos = res['data']['salesPerformanceForecastInfos']
      }
    })
  }

  //活动量得分统计
  queryPEPScore(){
    this.myService.queryPEPScore({ practitionerId: this.practitionerId ,sortType:this.sortType}).subscribe((res)=>{
      if(res['success']){
        this.personalList = res['data']['personalList'];
      }
    })
  }

  //团队成员列表
  queryTeamMemberDetail(){
    this.myService.queryTeamMemberDetail({practitionerId:this.practitionerId}).subscribe((res)=>{
      if(res['success']){
        this.teamMemberList = res['data']['teamMemberDetail'];
        this.teamList = res['data']['teamMemberList'];
        this.subordinateSystemName = res['data']['systemName'];
      }
    })
  }

  goToList(itemInfo) {
      this.router.navigate(['/member_list', itemInfo.systemType],{queryParams:{sid:itemInfo.sid}});
  }
}
