import { Component, OnInit } from '@angular/core';
import { MyService } from '../my.service';
import { LifeCommonService } from '../../common/life-common.service';
@Component({
  selector: 'ydlife-my-business',
  templateUrl: './my-business.component.html',
  styleUrls: ['./my-business.component.scss']
})
export class MyBusinessComponent implements OnInit {
  businessList: Array<any>;
  constructor(private myService: MyService, public lifeCommonService: LifeCommonService) { }

  ngOnInit() {
    this.ownOpportunityQuery()

  }

  ownOpportunityQuery() {
    const brokerCustomerId = JSON.parse(localStorage.getItem('lifeCustomerInfo'))['customerId'];
    this.myService.ownOpportunityQuery({ customerId: brokerCustomerId }).subscribe((res) => {
      if (res['data']['ownOpportunityInfos']) {
        this.businessList = res['data']['ownOpportunityInfos'];
      } else {
        this.businessList = []
      }
    })
  }


}
