import { Component, OnInit } from '@angular/core';
import { ActivatedRoute } from '@angular/router';
import { MyService } from 'src/app/my/my.service';

@Component({
  selector: 'ydlife-video',
  templateUrl: './video.component.html',
  styleUrls: ['./video.component.scss']
})
export class VideoComponent implements OnInit {
  filePath:string;
  fileId:string;
  constructor(private activatedRoute: ActivatedRoute, private myService: MyService) { }

  ngOnInit() {
   this.fileId = this.activatedRoute.snapshot.params.fileId;
   this.filePathQuery(null,this.fileId)
  }


  filePathQuery(status, fileId) {
    this.myService.filePath('3', '0', '23', 'yd_trainning_file_type', null, null, status, fileId).subscribe(res => {
      if(res['success']){
        const fileUploadItem = res['data']['fileUploadItemList'][0];
        this.filePath = `assets/pdfjs/web/viewer.html?file=${fileUploadItem.filePath}&isneeddownload=${fileUploadItem.isDownload=='1'?'true':'false'}`
      }
    })
  }
  
  menuPrevent() {
    return false;
  }

}
