import { Component, OnInit } from '@angular/core';
import { MyService } from '../my.service';
import { ActivatedRoute, Router } from "@angular/router";
import { EChartOption } from 'echarts';
@Component({
  selector: 'ydlife-score-details',
  templateUrl: './score-details.component.html',
  styleUrls: ['./score-details.component.scss']
})
export class ScoreDetailsComponent implements OnInit {
  salesScoreDetails: any;
  selectedTime: string;
  practitionerId:number;
  chartOption: EChartOption = {}
  constructor(private activateRoute: ActivatedRoute,private myService: MyService) { }


  ngOnInit() {
    this.selectedTime = 'D';
    this.queryPEPScoreDetail('D');
    if(this.activateRoute.snapshot.paramMap.get('practitionerId')){
      this.practitionerId = Number(this.activateRoute.snapshot.paramMap.get('practitionerId'));
    }else{
      this.practitionerId = JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId'];
    }
 
  }

  //销售活动量详情D-天 W-周 M-月
  queryPEPScoreDetail(time) {
    this.selectedTime = time;
    const practitionerId = JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId'];
    this.myService.queryPEPScoreDetail({ practitionerId: practitionerId, time: this.selectedTime }).subscribe((res) => {
      if (res['success']) {
        this.salesScoreDetails = res['data']['detail'];
        this.chartOption ={
          tooltip: {
            trigger: 'item',
            formatter: '{a} <br/>{b}: {c} ({d}%)'
          },
        legend: {
            orient: 'horizontal',
            bottom: 0,
            data: ['营销', '辅导', '会议', '培训', '增员'],
            itemWidth:10, 
            itemHeight:10,
        },
        series: [
            {
                name: 'PEP得分',
                type: 'pie',
                radius: ['20%', '40%'],
                avoidLabelOverlap: true,
                label: {
                  show: true,
                  position: 'outside',
                 //显示的标签的内容
                 formatter: "{b}:{c}分", 
                },
                emphasis: {
                    label: {
                        show: true,
                        fontSize: '18',
                        fontWeight: 'bold'
                    }
                },
                labelLine: {
                    show: true
                },
                data: [
                    {value: this.salesScoreDetails.saleScore, name: '营销',itemStyle:{color:'#CF3153FF'}},
                    {value: this.salesScoreDetails.coachScore, name: '辅导',itemStyle:{color:'#F1C13FFF'}},
                    {value: this.salesScoreDetails.meetingScore, name: '会议',itemStyle:{color:'#34A0BEFF'}},
                    {value: this.salesScoreDetails.trainScore, name: '培训',itemStyle:{color:'#5C66ADFF'}},
                    {value: this.salesScoreDetails.recruitScore, name: '增员',itemStyle:{color:'#00447AFF'}}
                ]
            }
        ]
        }
      }
    })
  }

}
