import {Injectable} from '@angular/core';
import {HttpClient} from '@angular/common/http';
import {environment} from '../../environments/environment';

@Injectable({
  providedIn: 'root'
})
export class MyService {
  constructor(private http: HttpClient) {
  }

  private API = environment.BACKEND_URL_CONFIG_VALUE;

//  保存分享码
  shareCallBack(shareInfo) {
    const url = this.API + '/shareCallBack';
    return this.http
      .post(url, JSON.stringify(shareInfo));
  }

//  文件下载
  filePath(itemType, itemId, fileCategory) {
    const url = this.API + '/filePathQuery';
    return this.http
      .post(url, JSON.stringify({itemType: itemType, itemId: itemId, fileCategory: fileCategory}));
  }

//  重要公告
  announcementQuery(id, announcementTypeId) {
    const url = this.API + '/announcementQuery';
    return this.http
      .post(url, JSON.stringify({id: id, announcementTypeId: announcementTypeId}));
  }

//  产品海报
  posterQuery(paginationInfo) {
    const url = this.API + '/posterQuery';
    return this.http
      .post(url, JSON.stringify(paginationInfo));
  }
}
