import { Component, OnDestroy, OnInit } from '@angular/core';
import { ActivatedRoute,Router } from "@angular/router";
import { LifeCommonService } from "../../../common/life-common.service";
import { MyService } from '../../my.service';
declare var rrweb:any;
@Component({
  selector: 'ydlife-employee-submit',
  templateUrl: './employee-submit.component.html',
  styleUrls: ['./employee-submit.component.scss']
})
export class EmployeeSubmitComponent implements OnInit {
  hiringBasicInfoId:any;
  approveStatus:any;
  isNeedAlert: boolean;
  dialogInfo: any;
   // 判断是哪个成功页面
   type:string;
   timerId:any;
   events:Array<any>;
   pageInfo = {
     type:10,
     name:'提交成功页'
   }
  constructor(private activatedRoute: ActivatedRoute,
    public lifeCommonService:LifeCommonService,
    private myService:MyService) { }

  ngOnInit() {
    sessionStorage.removeItem('viewApprovalInfo')
    const title = this.activatedRoute.snapshot.data[0]['title'];
    this.lifeCommonService.setTitle(title);
    this.hiringBasicInfoId = this.activatedRoute.snapshot.queryParams.hiringBasicInfoId?this.activatedRoute.snapshot.queryParams.hiringBasicInfoId:null;
    this.approveStatus = this.activatedRoute.snapshot.queryParams.status?this.activatedRoute.snapshot.queryParams.status:null;
    this.type = this.activatedRoute.snapshot.routeConfig.path;
    if(this.type!='eNotice_submit'){
      if(this.approveStatus == null || this.approveStatus == '-1'){
        this.hiringSubmit();
      }
    }
    this.creatRecord();
  }
  creatRecord(){
    let _this = this;
    _this.events = [];
    rrweb.record({
      emit(event){
        // 将evene存入events数组中
        _this.events.push(event);
        console.log('@@@',_this.events)
      },
      recordCanvas: true
    });
    setTimeout(()=>{
      this.myService.rrwebInfo(this.events,this.pageInfo).subscribe(res=>{

      })
    },5*1000)


  }
  hiringSubmit(){
    this.myService.hiringSubmit({hiringBasicInfoId:this.hiringBasicInfoId}).subscribe((res)=>{
      if(res['success']){

      }else{
        this.openPopInfo(res['message'])
      }
    })
  }

  // 打开弹窗
  openPopInfo(message) {
    this.isNeedAlert = true;
    this.dialogInfo = {
      title: null,
      content: { value: message, align: 'center' },
      footer: [{ value: '我知道了', routerLink: '', className: 'weui-dialog__btn_primary' }],
    };
  }

  // 关闭弹窗
  getPopInfo() {
    this.isNeedAlert = false;
  }

}
