import { Component, OnInit } from '@angular/core';
import { MyService } from '../my.service';
@Component({
  selector: 'ydlife-team-rank',
  templateUrl: './team-rank.component.html',
  styleUrls: ['./team-rank.component.scss']
})
export class TeamRankComponent implements OnInit {
  performanceListShow: Array<any>;
  performanceList: Array<any>;
  list: Array<any>;
  time: any;
  lineType: any;
  allPerformanceInfo: any;
  subordinateSystemName: string;
  statisticInfo: any;
  constructor(private myService: MyService) {
    this.performanceList = [
      { time: '1', name: '本月' },
      { time: '2', name: '本年' }
    ]
    this.list = [
      { type: 'online', name: '线上' },
      { type: 'underLine', name: '寿险' },
    ]
  }

  ngOnInit() {
    this.performanceListShow = [];
    this.subordinateSystemMemberQuery(1, 'online');
  }

  //初始化查询本月+线上
  subordinateSystemMemberQuery(time, online?: any) {
    this.time = time;
    this.lineType = online;
    const practitionerId = JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId'];
    //如果是寿险不显示
    if (online == 'underLine') {
      this.allPerformanceInfo = null
    } else {
      this.myService.subordinateSystemMemberQuery({ practitionerId: practitionerId, time: time }).subscribe((res) => {
        if (res['success']) {
          this.allPerformanceInfo = res['data'];
          this.subordinateSystemName = res['data']['subordinateSystemName'];
          this.statisticInfo = res['data']['statisticInfo'];
          this.performanceListShow = res['data']['memberInfoList'];
        }
      })
    }

  }


}
