import { Component, OnDestroy, OnInit } from '@angular/core';
import { ActivatedRoute } from "@angular/router";
import { Router } from '@angular/router';
import { MyService } from '../my.service';
declare var rrwebRecord:any;

@Component({
  selector: 'ydlife-e-notice',
  templateUrl: './e-notice.component.html',
  styleUrls: ['./e-notice.component.scss']
})
export class ENoticeComponent implements OnInit,OnDestroy {
  pageType:any;
  timerId:any;
  events:Array<any>;
  pageInfo = {
    type:5,
    name:'保单继续率承诺书同意签署页'
  }
  constructor(private activatedRoute: ActivatedRoute,private router:Router,private myService:MyService) {

   }

  ngOnInit() {
    this.pageType = this.activatedRoute.url['value'][0]['path'];
    let _this = this;
    _this.events = [];
    rrwebRecord({
      emit(event){
        // 将evene存入events数组中
        _this.events.push(event);
      }
    });
    this.timerId = setInterval(()=>{ this.saveRecord()},10 * 1000)
  }
  ngOnDestroy(): void {
      clearInterval(this.timerId)
  }

  saveRecord(){
    this.myService.rrwebInfo(this.events,this.pageInfo).subscribe(res=>{
      // console.log(res);
    })
  }
  agree(){
    this.saveRecord();
    this.myService.customerBehaviorTrackSave(`保单继续率承诺书 - ${JSON.parse(localStorage.getItem('lifeCustomerInfo')).practitionerBasicInfo.insurerBranchName}、${JSON.parse(localStorage.getItem('lifeCustomerInfo')).practitionerBasicInfo.subordinateName}体系下，经纪人${JSON.parse(localStorage.getItem('lifeCustomerInfo')).practitionerBasicInfo.name}点击了【同意并签署】`).subscribe(res=>{
      this.router.navigate(['/eNoticeSignature'],{ queryParams: { type:'continuationRate'} })
    })
  }
}
