import { Component, OnInit } from '@angular/core';
import { LifeCommonService } from '../../common/life-common.service';
import { MyService } from "../my.service";
import { ModalService, ToastService } from 'ng-zorro-antd-mobile';
import { ActivatedRoute,Router } from "@angular/router";

@Component({
  selector: 'ydlife-ask',
  templateUrl: './ask.component.html',
  styleUrls: ['./ask.component.scss']
})
export class AskComponent implements OnInit {
  problem:string;
  practitionerId:any;
  constructor(private activatedRoute: ActivatedRoute,
    private router:Router,private _toast: ToastService,public lifeCommonService: LifeCommonService,private myService:MyService) { }

  ngOnInit() {
    this.lifeCommonService.setTitle('提出问题');
    this.practitionerId = JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId'];

  }

  underwritingProblemSave(){
    if(!this.problem){
      const toast = ToastService.show('请输入您的问题！', 0);
      setTimeout(() => {
        ToastService.hide();
      }, 3000);
      return;
    }
    const Param ={
      problem:this.problem,
      questioner:this.practitionerId,
      isActive:1
    }
    this.myService.underwritingProblemSave(Param).subscribe((res)=>{
      console.log(res)
      if(res['success']){
        const toast = ToastService.show('您的问题已提交成功！', 0);
        setTimeout(() => {
          ToastService.hide();
        }, 3000);
        this.router.navigate(['/my_question']);
        return;
      }else{
        const toast = ToastService.show(res['message'], 0);
        setTimeout(() => {
          ToastService.hide();
        }, 3000);
      }
    })
  }
}
