import {NgModule} from '@angular/core';
import {Routes, RouterModule} from '@angular/router';
import {MyCenterHomeComponent} from './my-center-home/my-center-home.component';
import {AuthGuard} from '../auth/auth.guard';
import {MkMaterialComponent} from './mk-material/mk-material.component';
import {MkMaterialDetailComponent} from './mk-material-detail/mk-material-detail.component';
import {FileUploadComponent} from './file-upload/file-upload.component';
const myRoutes: Routes = [
  {path: '', component: MyCenterHomeComponent, canActivate: [AuthGuard]},
  {path: 'material', component: MkMaterialComponent},
  {path: 'material/:itemId', component: MkMaterialDetailComponent},
  {path: 'fileUpload', component: FileUploadComponent}
];

@NgModule({
  imports: [RouterModule.forChild(myRoutes)],
  exports: [RouterModule]
})
export class MyRoutingModule {
}
