import { Component, OnInit } from '@angular/core';
import { MyService } from '../my.service';
import { ActivatedRoute, Router } from "@angular/router";
import { LifeCommonService } from '../../common/life-common.service';
@Component({
  selector: 'ydlife-sales-detail',
  templateUrl: './sales-detail.component.html',
  styleUrls: ['./sales-detail.component.scss']
})
export class SalesDetailComponent implements OnInit {
  salesDetailList: Array<any>;
  searchType: any;
  performanceList: Array<any>;
  showType: any;
  platform: number;
  performanceTitle:string = '本月';
  constructor(private router: Router, private myService: MyService, private activatedRoute: ActivatedRoute, public lifeCommonService: LifeCommonService) {
    this.performanceList = [
      { time: 1, name: '本月' },
      { time: 3, name: '本季' },
      { time: 2, name: '本年度' },
      // { time: 4, name: '历史' }
    ]
  }

  ngOnInit() {
    this.searchType = this.activatedRoute.snapshot.queryParams.searchType;
    this.showType = this.activatedRoute.snapshot.queryParams.showType;
    this.platform = 1;
    this.practitionerPolicyListQuery(this.platform);
  }

  //查询保单
  practitionerPolicyListQuery(platform?: any) {
    const practitionerId = JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId'];
    this.myService.policyListQuery({ practitionerId: practitionerId, time: this.searchType }).subscribe((res) => {
      if (res['success']) {
        this.salesDetailList = res['data']['policyInfoList'];
        if (platform == 1) {
          this.salesDetailList = this.salesDetailList.filter(item => {
            return item.platform == 1;
          })
        } else {
          this.salesDetailList = this.salesDetailList.filter(item => {
            return item.platform == 2;
          })
        }
      } else {
        this.salesDetailList = [];
      }
    })
  }



  selectRang(e,name) {
    this.searchType = e;
    this.performanceTitle = name;
    this.practitionerPolicyListQuery(this.platform);
  }

  jumpToOrderdetail(orderNo, platform, fortuneId) {
    if (platform === 1) {
      const customerId = JSON.parse(localStorage.getItem('lifeCustomerInfo')).customerId;
      window.location.href = `https://${window.location.host}/mine/orderdetail/${orderNo}?customerId=${customerId}&isReferral=true&paid=true&fortuneId=${fortuneId}`;
    } else {
      this.router.navigate(['/orderDetail'], { queryParams: { orderNo: orderNo } });
    }
  }
}
