import { NgModule } from '@angular/core';
import { Routes, RouterModule } from '@angular/router';
import { MyCenterHomeComponent } from './my-center-home/my-center-home.component';
import { AuthGuard } from '../auth/auth.guard';
import { MkMaterialComponent } from './mk-material/mk-material.component';
import { MkMaterialDetailComponent } from './mk-material-detail/mk-material-detail.component';
import { FileUploadComponent } from './file-upload/file-upload.component';
import { ImportantAnnouncementComponent } from './important-announcement/important-announcement.component';
import { SalesDetailComponent } from './sales-detail/sales-detail.component';
import { AnnouncementDetailComponent } from './announcement-detail/announcement-detail.component';
import { MyBusinessComponent } from './my-business/my-business.component';
import { MyBusinessDetailComponent } from './my-business-detail/my-business-detail.component';
import { SalesRankComponent } from './sales-rank/sales-rank.component';
import { TeamRankComponent } from './team-rank/team-rank.component';
import { RecruitingComponent } from './recruiting/recruiting.component';
import { RecruitingDetailComponent } from './recruiting-detail/recruiting-detail.component';
import { ThanksComponent } from './thanks/thanks.component';
import { MySettingComponent } from './my-setting/my-setting.component';
import { MySettingDetailComponent } from './my-setting-detail/my-setting-detail.component';
import { MyNewsComponent } from './my-news/my-news.component';
import { MyTargetComponent } from "./my-target/my-target.component";
import { TeamPanelComponent } from './team-panel/team-panel.component';
import { TeamSalesScoreComponent } from './team-sales-score/team-sales-score.component';
import { ScoreDetailsComponent } from './score-details/score-details.component';
import { BusinessCardComponent } from "./business-card/business-card.component";
import { OrderDetailComponent } from './order-detail/order-detail.component';
import { SalaryComponent } from './salary/salary.component';
import { TodoListComponent } from './todo-list/todo-list.component';
import { AddTaskComponent } from './add-task/add-task.component';
import { MedicalServiceComponent } from './medical-service/medical-service.component';
import { InvitationComponent } from './application-process/invitation/invitation.component';
import { RegisterComponent } from './application-process/register/register.component';
import { EmployeeInfoComponent } from './application-process/employee-info/employee-info.component';
import { EmployeeBasicInfoComponent } from './application-process/employee-basic-info/employee-basic-info.component';
import { WorkExperienceComponent } from './application-process/work-experience/work-experience.component';
import { PersonalPhotosComponent } from './application-process/personal-photos/personal-photos.component';
import { EmployeeIdCardComponent } from './application-process/employee-id-card/employee-id-card.component';
import { EmployeeEducationComponent } from './application-process/employee-education/employee-education.component';
import { PersonalStatementComponent } from './application-process/personal-statement/personal-statement.component';
import { SignatureComponent } from './application-process/signature/signature.component';
import { EmployeeSubmitComponent } from './application-process/employee-submit/employee-submit.component';
import { BankCardComponent } from './application-process/bank-card/bank-card.component';
import { MemberDetailComponent } from './member-detail/member-detail.component';
import { ApprovalListComponent } from './approval-list/approval-list.component';
import { ApprovalCommentsComponent } from './approval-comments/approval-comments.component';
import { ApprovalResultListComponent } from './approval-result-list/approval-result-list.component';
import { MyApplicationComponent } from './my-application/my-application.component';
import { SuggestionComponent } from './suggestion/suggestion.component';
import { EmployeeSalaryComponent } from './application-process/employee-salary/employee-salary.component';
import { HistoricalRankComponent } from './historical-rank/historical-rank.component';
import { TeamAreaPanelComponent } from './team-area-panel/team-area-panel.component';
import { ArticleComponent } from './article/article.component';
import { ArticleDetailComponent } from './article-detail/article-detail.component';
import { ArticleReadComponent } from './article-read/article-read.component';
import { SalaryDetailComponent } from './salary-detail/salary-detail.component';
import { SalaryFirstYearComponent } from './salary-first-year/salary-first-year.component';
import { ProductComponent } from './product/product.component';
import { ProductDataComponent } from "./product-data/product-data.component";
import { CommissionComponent } from './commission/commission.component';
import { FileListComponent } from './file-list/file-list.component';
import { MyCustomerComponent } from './my-customer/my-customer.component';
import { CustomerRelationComponent } from './customer-relation/customer-relation.component';
import { MyCustomerPolicyComponent } from './my-customer-policy/my-customer-policy.component';
import { UnderwritingKnowledgeComponent } from './underwriting-knowledge/underwriting-knowledge.component';
import { MyQuestionComponent } from './my-question/my-question.component';
import { AskComponent } from './ask/ask.component';
import { MenuItemComponent } from './menu-item/menu-item.component';
import { MemberListComponent } from './member-list/member-list.component';
import { ENoticeComponent } from './e-notice/e-notice.component';
import { RenewalReminderComponent } from './renewal-reminder/renewal-reminder.component';
import { RenewalReminderDetailComponent } from './renewal-reminder-detail/renewal-reminder-detail.component';
import { JointSalesComponent } from './joint-sales/joint-sales.component';
import { JointSaleDetailComponent } from './joint-sale-detail/joint-sale-detail.component';
import { IntegrationComponent } from './integration/integration.component';
import { IntegrationDetailComponent } from './integration-detail/integration-detail.component';
import { IntegrationRuleComponent } from './integration-rule/integration-rule.component';
import { VideoComponent } from '../common/video/video.component';
import { QrcodeUploadComponent } from './application-process/qrcode-upload/qrcode-upload.component';
import { NewsDetailComponent } from './news-detail/news-detail.component';
import { MoreFeaturesComponent } from './more-features/more-features.component';
import { MineComponent } from './mine/mine.component';


const myRoutes: Routes = [
  { path: '', component: MyCenterHomeComponent, canActivate: [AuthGuard], data: [{ title: '银盾保险经纪 - 工作台' }] },
  { path: 'material', component: MkMaterialComponent, canActivate: [AuthGuard] },
  { path: 'material/:itemId', component: MkMaterialDetailComponent, canActivate: [AuthGuard] },
  { path: 'fileUpload', component: FileUploadComponent, canActivate: [AuthGuard], data: [{ type: 'fileUpload' }] },
  { path: 'training', component: FileUploadComponent, canActivate: [AuthGuard], data: [{ type: 'training' }] },
  { path: 'trainingVideo', component: FileUploadComponent, canActivate: [AuthGuard], data: [{ type: 'trainingVideo' }] },
  { path: 'prejobTraining', component: FileUploadComponent, canActivate: [AuthGuard], data: [{ type: 'yd_trainning_file_type' }] },
  { path: 'newTraining', component: FileUploadComponent, canActivate: [AuthGuard], data: [{ type: 'yd_trainning_file_type' }] },
  { path: 'advanceTraining', component: FileUploadComponent, canActivate: [AuthGuard], data: [{ type: 'yd_trainning_file_type' }] },
  { path: 'cffpTraining', component: FileUploadComponent, canActivate: [AuthGuard], data: [{ type: 'yd_trainning_file_type' }] },
  { path: 'productTraining', component: FileUploadComponent, canActivate: [AuthGuard], data: [{ type: 'yd_trainning_file_type' }] },
  { path: 'importantAnnouncement', component: ImportantAnnouncementComponent, canActivate: [AuthGuard] },
  { path: 'salesDetail', component: SalesDetailComponent, canActivate: [AuthGuard] },
  { path: 'importantAnnouncement/:id', component: AnnouncementDetailComponent, canActivate: [AuthGuard] },
  { path: 'business', component: MyBusinessComponent, canActivate: [AuthGuard],data:[{type:'business'}] },
  { path: 'linkbusiness', component: MyBusinessComponent, canActivate: [AuthGuard],data:[{type:'linkbusiness'}] },
  { path: 'business/:id', component: MyBusinessDetailComponent, canActivate: [AuthGuard] },
  { path: 'rank', component: SalesRankComponent, canActivate: [AuthGuard] },
  { path: 'teamRank', component: TeamRankComponent, canActivate: [AuthGuard] },
  { path: 'recruiting', component: RecruitingComponent, canActivate: [AuthGuard] ,data:[{type:'recruiting'}]},
  { path: 'linkrecruiting', component: RecruitingComponent, canActivate: [AuthGuard] ,data:[{type:'linkrecruiting'}]},
  { path: 'recruiting/:id', component: RecruitingDetailComponent, canActivate: [AuthGuard] },
  { path: 'thanks', component: ThanksComponent, canActivate: [AuthGuard] },
  { path: 'setting', component: MySettingComponent, canActivate: [AuthGuard] },
  { path: 'setting/:uploadType', component: MySettingDetailComponent, canActivate: [AuthGuard] },
  { path: 'news', component: MyNewsComponent, canActivate: [AuthGuard] },
  { path: 'target', component: MyTargetComponent, canActivate: [AuthGuard] },
  { path: 'teamPanel', component: TeamPanelComponent, canActivate: [AuthGuard] },
  { path: 'teamPanel/:type', component: TeamSalesScoreComponent, canActivate: [AuthGuard] },
  { path: 'scoreDeatil', component: ScoreDetailsComponent, canActivate: [AuthGuard] },
  { path: 'scoreDeatil/:practitionerId', component: ScoreDetailsComponent, canActivate: [AuthGuard] },
  { path: 'businessCard', component: BusinessCardComponent, canActivate: [AuthGuard] },
  { path: 'orderDetail', component: OrderDetailComponent, canActivate: [AuthGuard] },
  { path: 'salary', component: SalaryComponent, canActivate: [AuthGuard],data:[{title:'我的薪资'}] },
  { path: 'todo', component: TodoListComponent, canActivate: [AuthGuard] },
  { path: 'addtask',component:AddTaskComponent,canActivate:[AuthGuard]},
  { path: 'medical_service',component:MedicalServiceComponent,canActivate:[AuthGuard]},
  { path: 'inviter' ,component:InvitationComponent,canActivate:[AuthGuard],data:[{type:'inviter',title: '邀请函'}]},
  { path: 'invitees' ,component:InvitationComponent,data:[{type:'invitees',title: '邀请函'}]},
  { path: 'register' ,component:RegisterComponent,data: [{ title: '注册信息' }]},
  { path: 'identify' ,component:RegisterComponent,data: [{ title: '客户告知书和保险经纪服务委托协议' }]},
  { path: 'employee_info',component:EmployeeInfoComponent,data: [{ title: '银盾经纪人报聘' }]},
  { path: 'employee_basic_info',component:EmployeeBasicInfoComponent,data: [{ title: '银盾经纪人报聘' }] },
  { path: 'work_experience',component:WorkExperienceComponent,data: [{ title: '银盾经纪人报聘' }] },
  { path: 'personal_photos',component:PersonalPhotosComponent,data: [{ title: '银盾经纪人报聘' }] },
  { path: 'employee_id_card',component:EmployeeIdCardComponent,data: [{ title: '银盾经纪人报聘' }] },
  { path: 'employee_education',component:EmployeeEducationComponent,data: [{ title: '银盾经纪人报聘' }] },
  { path: 'bank_card',component:BankCardComponent,data:[{title:'银盾经纪人报聘'}]},
  { path: 'employee_salary',component:EmployeeSalaryComponent,data: [{ title: '银盾经纪人报聘' }] },
  { path: 'qrcode_upload',component:QrcodeUploadComponent,data: [{ title: '银盾经纪人报聘' }] },
  { path: 'personal_statement',component:PersonalStatementComponent,data: [{ type:'personal_statement',title: '银盾经纪人报聘' }] },
  { path: 'contract',component:PersonalStatementComponent,data: [{ type:'contract',title: '银盾经纪人报聘' }] },
  { path: 'signature',component:SignatureComponent,data: [{ title: '银盾经纪人报聘' }]},
  { path: 'eNoticeSignature',component:SignatureComponent,data: [{ title: '客户告知书和保险经纪服务委托协议' }]},
  { path: 'employee_submit',component:EmployeeSubmitComponent,data: [{ title: '已提交' }]},
  { path: 'eNotice_submit',component:EmployeeSubmitComponent,data: [{ title: '已提交' }]},
  { path: 'member_detail/:practitionerId',component:MemberDetailComponent, canActivate: [AuthGuard]},
  { path: 'approval_list',component:ApprovalListComponent, data: [{ title: '审批列表' }],canActivate: [AuthGuard]},
  { path: 'approval_comments',component:ApprovalCommentsComponent,canActivate:[AuthGuard]},
  { path: 'approval_result_list',component:ApprovalResultListComponent,data: [{ title: '审批流程' }],canActivate:[AuthGuard]},
  { path: 'my_application',component:MyApplicationComponent,data: [{ title: '我的报聘' }],canActivate:[AuthGuard]},
  { path: 'suggestion',component:SuggestionComponent,data: [{ title: '问题反馈' }],canActivate:[AuthGuard]},
  { path: 'historical_rank', component: HistoricalRankComponent, canActivate: [AuthGuard] },
  { path: 'team_area',component:TeamAreaPanelComponent, canActivate: [AuthGuard]},
  { path: 'article/:mdDropOptionId', component:ArticleComponent},
  { path: 'articleDetail/:id',component:ArticleDetailComponent},
  { path: 'article_read/:id',component:ArticleReadComponent,canActivate:[AuthGuard]},
  { path: 'salary_detail',component:SalaryDetailComponent,canActivate:[AuthGuard]},
  { path: 'salary_detail/:id',component:SalaryFirstYearComponent,canActivate:[AuthGuard]},
  { path: 'product',component:ProductComponent,canActivate:[AuthGuard]},
  { path: 'productData/:id',component:ProductDataComponent,canActivate:[AuthGuard]},
  { path: 'commission',component:CommissionComponent,canActivate:[AuthGuard]},
  { path: 'filelist',component:FileListComponent,canActivate:[AuthGuard]},
  { path: 'customer',component:MyCustomerComponent,canActivate:[AuthGuard]},
  { path: 'customer_relation',component:CustomerRelationComponent,canActivate:[AuthGuard]},
  { path: 'customer_policy',component:MyCustomerPolicyComponent,canActivate:[AuthGuard]},
  { path: 'underwriting_knowledge',component:UnderwritingKnowledgeComponent,canActivate:[AuthGuard]},
  { path: 'my_question',component:MyQuestionComponent,canActivate:[AuthGuard]},
  { path: 'ask',component:AskComponent,canActivate:[AuthGuard]},
  { path: 'marketing',component:MenuItemComponent,data:[{title:'银盾保经-营销工具',type:'marketing'}],canActivate:[AuthGuard]},
  { path: 'team',component:MenuItemComponent,data:[{title:'银盾保经-我的团队',type:'team'}],canActivate:[AuthGuard]},
  { path: 'exhibition',component:MenuItemComponent,data:[{title:'银盾保经-我的展业',type:'exhibition'}],canActivate:[AuthGuard]},
  { path: 'trainingCenter',component:MenuItemComponent,data:[{title:'银盾保经-教育培训',type:'trainingCenter'}],canActivate:[AuthGuard]},
  { path: 'newPeople',component:MenuItemComponent,data:[{title:'银盾保经-新人入口',type:'newPeople'}],canActivate:[AuthGuard]},
  { path: 'member_list/:systemType',component:MemberListComponent,canActivate:[AuthGuard]},
  { path: 'continuation_rate_commitment',component:ENoticeComponent,canActivate:[AuthGuard],data:{type:2}},
  { path: 'eNoticeSign',component:ENoticeComponent,data:{type:1,title: '客户告知书和保险经纪服务委托协议'}},
  { path: 'renewal_reminder',component:RenewalReminderComponent,canActivate:[AuthGuard],data:{type:1,title: '续期提醒'}},
  { path: 'renewal_reminder_detail/:orderPayId',component:RenewalReminderDetailComponent,canActivate:[AuthGuard],data:{type:1,title: '续期订单提醒'}},
  { path: 'reminder_detail/:orderPayId',component:RenewalReminderDetailComponent,data:{type:2,title: '续期订单详情信息'}},
  { path: 'joint_sales',component:JointSalesComponent,canActivate:[AuthGuard],data:{title: '联合销售列表'}},
  { path: 'joint_sales_detail/:unionSalesId',component:JointSaleDetailComponent,canActivate:[AuthGuard],data:{title: '联合销售签署'}},
  { path: 'integration',component:IntegrationComponent,canActivate:[AuthGuard],data:{title: '我的积分'}},
  { path: 'integration_detail',component:IntegrationDetailComponent,canActivate:[AuthGuard],data:{title: '积分明细'}},
  { path: 'integration_rule',component:IntegrationRuleComponent,canActivate:[AuthGuard],data:{title: '积分规则'}},
  { path: 'video',component:VideoComponent,canActivate:[AuthGuard],data:{title: '视频播放'}},
  { path: 'pdfView',component:VideoComponent,canActivate:[AuthGuard],data:{title: 'PDF查看'}},
  { path: 'newsDetail/:id',component:NewsDetailComponent,canActivate:[AuthGuard],data:{title: '消息详情'}},
  { path: 'moreFeatures',component:MoreFeaturesComponent,canActivate:[AuthGuard],data:{title: '全部工具'}},
  { path: 'mine',component:MineComponent,canActivate:[AuthGuard],data:{title: '全部工具'}},

];

@NgModule({
  imports: [RouterModule.forChild(myRoutes)],
  exports: [RouterModule]
})
export class MyRoutingModule {
}
