import { Component, OnInit  } from '@angular/core';
import { MyService } from '../my.service';

@Component({
  selector: 'ydlife-integration-detail',
  templateUrl: './integration-detail.component.html',
  styleUrls: ['./integration-detail.component.scss']
})
export class IntegrationDetailComponent implements OnInit {
  integralGrantInfos:Array<any>;
  lists:Array<any>;
  status:number = 0;
  searchDate:string = '2022年';
  searchDateFormat:Date = new Date(2022, 1);
  constructor(private myService:MyService) { }

  ngOnInit() {
    this.queryPractitionerIntegralList();
  }
  queryLists(status){
    this.status = status;
    if(status!==0){
      this.lists = this.integralGrantInfos.filter(item=>item.integralType == status)
    }else{
      this.lists = this.integralGrantInfos;
    }
  }
  queryPractitionerIntegralList(queryDateStart=null,queryDateEnd=null){
    this.myService.queryPractitionerIntegralList({queryStatus:1,practitionerId:localStorage.getItem('lifeCustomerInfo')?JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId']:null,queryDateStart:queryDateStart,queryDateEnd:queryDateEnd}).subscribe(res=>{
      if(res['success']){
        this.lists = this.integralGrantInfos = res['data']['integralGrantInfos']
      }
    })
  }

  currentDateFormat(date, format: string = 'yyyy-mm'): any {
    const pad = (n: number): string => (n < 10 ? `0${n}` : n.toString());
    return format
      .replace('yyyy', date.getFullYear())
      .replace('mm', pad(date.getMonth() + 1))
      .replace('dd', pad(date.getDate()))
      .replace('HH', pad(date.getHours()))
      .replace('MM', pad(date.getMinutes()))
      .replace('ss', pad(date.getSeconds()));
  }

  onOk(result: Date) {
    this.searchDate = this.currentDateFormat(result);
    this.searchDateFormat = result;
    this.queryPractitionerIntegralList(this.searchDate + '-01')
  }
}
